% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-msaenet.R
\name{plot.msaenet}
\alias{plot.msaenet}
\title{Plot msaenet Model Objects}
\usage{
\method{plot}{msaenet}(x, ...)
}
\arguments{
\item{x}{An object of class \code{msaenet} produced
by \code{\link{aenet}}, \code{amnet}, \code{asnet},
\code{\link{msaenet}}, \code{\link{msamnet}}, or \code{\link{msasnet}}.}

\item{...}{Other parameters (not used).}
}
\description{
Plot msaenet model objects.
}
\examples{
dat = msaenet.sim.gaussian(n = 150, p = 500, rho = 0.6,
                           coef = rep(1, 5), snr = 2, p.train = 0.7,
                           seed = 1001)

msaenet.fit = msaenet(dat$x.tr, dat$y.tr,
                      alphas = seq(0.2, 0.8, 0.2),
                      nsteps = 3L, seed = 1003)
plot(msaenet.fit)
}
\author{
Nan Xiao <\url{http://nanx.me}>
}

