% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrbin.R
\name{plotMultiNMR}
\alias{plotMultiNMR}
\title{A function for plotting NMR spectra.}
\usage{
plotMultiNMR(
  region = NULL,
  rectangleRegions = NULL,
  rectangleColors = c("green", "orange", "blue", "red", "yellow", "gray", "purple"),
  rectangleFront = FALSE,
  polygonRegion = NULL,
  color = NULL,
  add = FALSE,
  showGrid = FALSE,
  manualScale = TRUE,
  plotTitle = "",
  restrictToRange = FALSE
)
}
\arguments{
\item{region}{A vector defining the plot region (left, right, top, bottom)}

\item{rectangleRegions}{A 4-column matrix defining areas where to plot rectangles}

\item{rectangleColors}{Define colors for the rectangles}

\item{rectangleFront}{Plot rectangles in front of spectrum rather than in background (only 2D)}

\item{polygonRegion}{Defines 4 corners of a polygon to be plotted}

\item{color}{Defines the color of the spectrum plot. If NULL, a rainbow theme is used for 2D NMR}

\item{add}{If TRUE, additional spectrum plots are overlaid with the current plot}

\item{showGrid}{Shows a grid of data points. Defaults to FALSE}

\item{manualScale}{If TRUE, scaling factor is taken from environment variables}

\item{plotTitle}{Defines the main title of the plot}

\item{restrictToRange}{Restrict plot area to range of available data points. Defaults to FALSE}
}
\value{
{None}
}
\description{
This function plots the current NMR spectrum. If no parameters are provided, parameters
are read from the mrbin.env environment variables, set by mrbin.
To change the plot, use zoom(),
zoomIn(), zoomOut(), intPlus(), intMin(), left(), right().
For 2D data use additionally: contMin(), contPlus(), up(), down()
}
\examples{
mrbin(silent=TRUE,setDefault=TRUE,parameters=list(dimension="1D",binwidth1D=.1,
         PQNScaling="No",noiseRemoval="No",trimZeros="No",
         fixNegatives="No",logTrafo="No",PCA="No",verbose=TRUE,
         NMRfolders=system.file("extdata/1/10/pdata/10",package="mrbin")))
plotMultiNMR()
}
