% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_ID_Report.R
\name{get_ID_Report}
\alias{get_ID_Report}
\title{Report for identifications}
\usage{
get_ID_Report(input_list)
}
\arguments{
\item{input_list}{A list with data frames and respective level information.}
}
\value{
This function returns a list. For each analysis a respective data frame including number of identifications per run is stored in the generated list.
\itemize{
\item Analysis - analysis name.
\item Run - run information.
\item Precursor.IDs - number of precursor identification.
\item Peptide.IDs - number of peptide identification.
\item Protein.IDs - number of protein identification.
\item ProteinGroup.IDs - number of proteingroup identification.
}
}
\description{
Generates a report for identifications
}
\details{
For each submitted data a report with achieved number of identifications is generated on precursor-, peptide-, protein- and proteingroup-level.
}
\examples{
# Load libraries
library(tibble)
library(stringr)

# Example data
data <- list(
DIANN = list(
  filename = "B",
  software = "DIA-NN",
  data = list(
     "DIA-NN" = tibble::tibble(
        Run_mpwR = rep(c("A","B"), times = 10),
        Precursor.IDs_mpwR = rep(c("A2", "A3", "B2", "B3", "C1"), each = 4),
        Protein.IDs_mpwR = rep(c("A2", "A3", "B2", "B3", "C1"), each = 4),
        Peptide.IDs_mpwR = rep(c("A", "A", "B", "B", "C"), each = 4),
        ProteinGroup.IDs_mpwR = rep(c("A2", "A3", "B2", "B3", "C1"), each = 4)
     )
  )
)
)

# Result
output <- get_ID_Report(
  input_list = data
)
}
\author{
Oliver Kardell
}
