% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_extract.R
\name{residuals.cmp}
\alias{residuals.cmp}
\title{Extract COM-Poisson Model Residuals}
\usage{
\method{residuals}{cmp}(object, type = c("deviance", "pearson",
  "response"), ...)
}
\arguments{
\item{object}{an object class 'cmp', obtained from a call to \code{glm.cmp}.}

\item{type}{the \code{type} of residuals which should be returned. The alternatives are:
'deviance' (default), 'pearson' and 'response'. Can be abbreviated.}

\item{...}{other arguments passed to or from other methods  (currently unused).}
}
\value{
Residuals extracted from the object \code{object}.
}
\description{
\code{residuals} is a generic function which extracts model residuals from objects 
returned by the modelling function \code{glm.comp}. \code{resid} is an alias for 
\code{residuals} .
}
\seealso{
\code{\link{coef.cmp}}, \code{\link{fitted.cmp}}, \code{\link{glm.cmp}}
}
