% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_pactr-accessors.R
\name{filter_summary}
\alias{filter_summary}
\title{Return the summary for a single mpactr filter.}
\usage{
filter_summary(mpactr_object, filter, group = NULL)
}
\arguments{
\item{mpactr_object}{The mpactr object that is created by calling
the import_data() function.}

\item{filter}{The name of a filter whose summary is to be extracted.
Must be one of: "mispicked", "group", "replicability", or "insource".}

\item{group}{If filter = "group", the name of the Biological_Group
used to filter.}
}
\value{
a \code{list} reporting 1) compound ids for compounds which failed
the filter and 2) compound ids for compounds which passed the filter.
}
\description{
\code{filter_summary()} is a wrapper function to return the summary
from a single filter within the given mpactr object.
}
\examples{
data <- import_data(example_path("coculture_peak_table.csv"),
  example_path("metadata.csv"),
  format = "Progenesis"
)

data_filter <- filter_mispicked_ions(data)

mispicked_summary <- filter_summary(data_filter, filter = "mispicked")
mispicked_summary

}
