% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define_questions_from.R
\name{define_questions_from_csv}
\alias{define_questions_from_csv}
\alias{define_questions_from_csv.question_category}
\title{Define questions from a csv file}
\usage{
define_questions_from_csv(qc, file, sep)

\method{define_questions_from_csv}{question_category}(qc, file, sep = ",")
}
\arguments{
\item{qc}{A \code{question_category} object.}

\item{file}{A string, name of a text file.}

\item{sep}{Column separator character.}
}
\value{
A \code{question_category}.
}
\description{
Each row in the text file is interpreted as a question. We only have to define
the columns that we are going to use, the rest of the columns are taken by default.
}
\details{
For answers where a vector is required, "<|>" is used as a separator of the vector
elements.
}
\examples{

file <- system.file("extdata", "questions.csv", package = "moodef")
qc <-
  question_category(category = 'Initial test', adapt_images = TRUE) |>
  define_questions_from_csv(file = file)

}
\seealso{
Other question definition: 
\code{\link{define_question}()},
\code{\link{define_questions_from_data_frame}()},
\code{\link{define_questions_from_excel}()},
\code{\link{generate_xml}()},
\code{\link{generate_xml_file}()},
\code{\link{question_category}()}
}
\concept{question definition}
