% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{mock}
\alias{mock}
\alias{mock_call}
\alias{mock_args}
\alias{mock_arg}
\alias{mock_n_called}
\title{Mocking helper functions}
\usage{
mock(expr, env = parent.frame())

mock_call(x, call_no = mock_n_called(x))

mock_args(x, call_no = mock_n_called(x))

mock_arg(x, arg, call_no = mock_n_called(x))

mock_n_called(x)
}
\arguments{
\item{expr}{Expression to be used as body of the function to be mocked.}

\item{env}{Environment used as ancestor to the mock function environment.}

\item{x}{Object of class \code{mock_fun} to be queried for call and argument
information.}

\item{call_no}{The call number of interest (in case the function was called
multiple times).}

\item{arg}{String-valued argument name to be retrieved.}
}
\value{
\itemize{
\item \code{mock()}: a \code{mock_fun} object
\item \code{mock_call()}: a call (created by \code{\link[base:match.call]{base::match.call()}})
\item \code{mock_arg()}: the object used as specified function argument
\item \code{mock_args()}: a list of all function arguments used to create a call to
the \code{mock_fun} object in question
\item \code{mock_n_called()}: a scalar integer
}
}
\description{
Calls to mock-objects either constructed using \code{mock()} or returned by
\code{local_mock()} can keep track of how they were called and functions
\code{mock_call()}, \code{mock_arg/s()} and \code{mock_n_called()} can be used to retrieve
related information.
}
\details{
A mocking function can be created either from a single object to be used
as return value or from an expression which is used as function body. In
both cases, the function signature is inferred from the mock-target.
Furthermore, closures constructed by \code{mock()} are able to keep track of
call objects and arguments passed to their respective targets. The
following utility functions are available to query this information:
\itemize{
\item \code{mock_call()}: retrieves the call captured by \code{\link[base:match.call]{base::match.call()}}
\item \code{mock_arg()}: retrieves the value of the argument with name passed as
string-valued argument \code{arg}
\item \code{mock_args()}: retrieves a list of all arguments used for calling the
mocked function
\item \code{mock_n_called()}: counts the number of times the mocked function was
called
}

Calls to mock objects are indexed chronologically and both \code{mock_call()}
and \code{mock_args()} provide an argument \code{call_no} which can be used to specify
which call is of interest, with the default being the most recent (or last)
one.
}
\examples{
url <- "https://eu.httpbin.org/get?foo=123"

mk <- mock("mocked request")
dl <- function(x) curl::curl(x)

with_mock(`curl::curl` = mk, dl(url))

mock_call(mk)
mock_args(mk)
mock_n_called(mk)

mk <- mock({
  url
})

with_mock(`curl::curl` = mk, dl(url))

my_return_val <- "mocked request"
mk <- mock(my_return_val)

with_mock(`curl::curl` = mk, dl(url))

}
