% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/digit.curves.R
\name{digit.curves.p}
\alias{digit.curves.p}
\title{Creates homogeneous level curve for every model (adapted from the function digit.curves
of the geomorph package)}
\usage{
digit.curves.p(start, curve, nPoints, closed = TRUE)
}
\arguments{
\item{start}{A numeric vector of x,y, coordinates for the landmark defining the start of the curve}

\item{curve}{A matrix (p x k) of 2D coordinates for a set of ordered points defining a curve}

\item{nPoints}{Numeric how many semilandmarks to place equidistantly along the curve (not counting beginning and end points)}

\item{closed}{Logical Whether the curve is closed (TRUE) or open (FALSE)}
}
\value{
A matrix of coordinates for nPoints equally spaced semilandmarks sampled along the curve
}
\description{
Creates homogeneous level curve for every model (adapted from the function digit.curves
of the geomorph package)
}
\examples{
x<-seq(0,30, length=200)
y=90-x^2
curve=data.frame(x,y)
ltl<-digit.curves.p(start=curve[1,], curve=as.matrix(curve), nPoints=98, closed = FALSE)
plot(ltl)
}
\references{
Bookstein, F. J. 1997 Landmark Methods for Forms without Landmarks: Morphometrics of
Group Differences in Outline Shape. Medical Image Analysis 1(3):225-243.

Rohlf, F.J., 2015. The tps series of software. Hystrix 26(1):9-12.
}
\seealso{
\code{\link[geomorph]{digit.curves}}
}
