% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_packages_installed.R
\name{check_packages_installed}
\alias{check_packages_installed}
\title{Check that packages are installed, without loading them}
\usage{
check_packages_installed(
  pkgs,
  warn = TRUE,
  msg = "The following packages are required but not installed: \%s"
)
}
\arguments{
\item{pkgs}{(\code{character()})\cr
Packages to check.}

\item{warn}{(\code{logical(1)})\cr
If \code{TRUE}, signals a warning of class \code{"packageNotFoundWarning"} about the missing packages.}

\item{msg}{(\code{character(1)})\cr
Format of the warning message. Use \code{"\%s"} as placeholder for the list of packages.}
}
\value{
(\code{logical()}) named with package names. \code{TRUE} if the respective package is installed, \code{FALSE} otherwise.
}
\description{
Calls \code{\link[=find.package]{find.package()}} to check if the all packages are installed.
Returns a
}
\examples{
check_packages_installed(c("mlr3misc", "foobar"), warn = FALSE)

# catch warning
tryCatch(check_packages_installed(c("mlr3misc", "foobaaar")),
  packageNotFoundWarning = function(w) as.character(w))
}
