% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/Measure_make_cost.R
\name{makeCostMeasure}
\alias{makeCostMeasure}
\title{Creates a measure for non-standard misclassification costs.}
\usage{
makeCostMeasure(id = "costs", minimize = TRUE, costs, task,
  combine = mean, best = NULL, worst = NULL)
}
\arguments{
\item{id}{[\code{character(1)}]\cr
Name of measure.
Default is \dQuote{costs}.}

\item{minimize}{[\code{logical(1)}]\cr
Should the measure be minimized?
Otherwise you are effectively specifying a benefits matrix.
Default is \code{TRUE}.}

\item{costs}{[\code{matrix}]\cr
Matrix of misclassification costs. Rows and columns have to be named with class labels, order does not matter.
Rows indicate true classes, columns predicted classes.}

\item{task}{[\code{\link{ClassifTask}}]\cr
Classification task. Has to be passed, so validity of matrix names can be checked.}

\item{combine}{[\code{function}]\cr
How to combine costs over all cases for a SINGLE test set?
Note this is not the same as the \code{aggregate} argument in \code{\link{makeMeasure}}
You can set this as well via \code{\link{setAggregation}}, as for any measure.
Default is \code{\link{mean}}.}

\item{best}{[\code{numeric(1)}]\cr
Best obtainable value for measure.
Default is -\code{Inf} or \code{Inf}, depending on \code{minimize}.}

\item{worst}{[\code{numeric(1)}]\cr
Worst obtainable value for measure.
Default is \code{Inf} or -\code{Inf}, depending on \code{minimize}.}
}
\value{
[\code{\link{Measure}}].
}
\description{
Creates a measure for non-standard misclassification costs.
}
\seealso{
Other performance: \code{\link{G1}}, \code{\link{G2}},
  \code{\link{acc}}, \code{\link{auc}}, \code{\link{bac}},
  \code{\link{ber}}, \code{\link{cindex}},
  \code{\link{db}}, \code{\link{dunn}}, \code{\link{f1}},
  \code{\link{fdr}}, \code{\link{featperc}},
  \code{\link{fn}}, \code{\link{fnr}}, \code{\link{fp}},
  \code{\link{fpr}}, \code{\link{gmean}},
  \code{\link{gpr}}, \code{\link{mae}}, \code{\link{mcc}},
  \code{\link{mcp}}, \code{\link{meancosts}},
  \code{\link{measureACC}}, \code{\link{measureAUC}},
  \code{\link{measureBAC}}, \code{\link{measureFDR}},
  \code{\link{measureFN}}, \code{\link{measureFNR}},
  \code{\link{measureFP}}, \code{\link{measureFPR}},
  \code{\link{measureGMEAN}}, \code{\link{measureGPR}},
  \code{\link{measureMAE}}, \code{\link{measureMCC}},
  \code{\link{measureMEDAE}}, \code{\link{measureMEDSE}},
  \code{\link{measureMMCE}}, \code{\link{measureMSE}},
  \code{\link{measureNPV}}, \code{\link{measurePPV}},
  \code{\link{measureRMSE}}, \code{\link{measureSAE}},
  \code{\link{measureSSE}}, \code{\link{measureTN}},
  \code{\link{measureTNR}}, \code{\link{measureTP}},
  \code{\link{measureTPR}}, \code{\link{measures}},
  \code{\link{medae}}, \code{\link{medse}},
  \code{\link{mmce}}, \code{\link{mse}},
  \code{\link{multiclass.auc}}, \code{\link{npv}},
  \code{\link{ppv}}, \code{\link{rmse}}, \code{\link{sae}},
  \code{\link{silhouette}}, \code{\link{sse}},
  \code{\link{timeboth}}, \code{\link{timepredict}},
  \code{\link{timetrain}}, \code{\link{tn}},
  \code{\link{tnr}}, \code{\link{tp}}, \code{\link{tpr}};
  \code{\link{Measure}}, \code{\link{makeMeasure}};
  \code{\link{makeCustomResampledMeasure}};
  \code{\link{performance}}
}

