% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getOOBPreds.R
\name{getOOBPreds}
\alias{getOOBPreds}
\title{Extracts out-of-bag predictions from trained models.}
\usage{
getOOBPreds(model, task)
}
\arguments{
\item{model}{[\code{\link{WrappedModel}}]\cr
The model.}

\item{task}{[\code{\link{Task}}]\cr
The task.}
}
\value{
[\code{\link{Prediction}}].
}
\description{
Learners like \code{randomForest} produce out-of-bag predictions. 
\code{getOOBPreds} extracts this information from trained models and builds a 
prediction object as provided by predict (with prediction time set to NA). 
In the classification case: 
What is stored exactly in the [\code{\link{Prediction}}] object depends
on the \code{predict.type} setting of the \code{\link{Learner}}.

You can call \code{listLearners(properties = "oobpreds")} to get a list of learners 
which provide this.
}
\examples{
training.set = sample(1:150, 50)
lrn = makeLearner("classif.ranger", predict.type = "prob", predict.threshold = 0.6)
mod = train(lrn, sonar.task, subset = training.set)
oob = getOOBPreds(mod, sonar.task)
oob
performance(oob, measures = list(auc, mmce))
}
