% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tracking-client.R
\name{mlflow_client_create_run}
\alias{mlflow_client_create_run}
\title{Create Run}
\usage{
mlflow_client_create_run(client, experiment_id, user_id = NULL,
  run_name = NULL, source_type = NULL, source_name = NULL,
  entry_point_name = NULL, start_time = NULL, source_version = NULL,
  tags = NULL)
}
\arguments{
\item{client}{An `mlflow_client` object.}

\item{experiment_id}{Unique identifier for the associated experiment.}

\item{user_id}{User ID or LDAP for the user executing the run.}

\item{run_name}{Human readable name for run.}

\item{source_type}{Originating source for this run. One of Notebook, Job, Project, Local or Unknown.}

\item{source_name}{String descriptor for source. For example, name or description of the notebook, or job name.}

\item{entry_point_name}{Name of the entry point for the run.}

\item{start_time}{Unix timestamp of when the run started in milliseconds.}

\item{source_version}{Git version of the source code used to create run.}

\item{tags}{Additional metadata for run in key-value pairs.}
}
\description{
reate a new run within an experiment. A run is usually a single execution of a machine learning or data ETL pipeline.
}
\details{
MLflow uses runs to track Param, Metric, and RunTag, associated with a single execution.

The Tracking Client family of functions require an MLflow client to be
  specified explicitly. These functions allow for greater control of where the
  operations take place in terms of services and runs, but are more verbose
  compared to the Fluent API.
}
\seealso{
Other Tracking client functions: \code{\link{mlflow_client_create_experiment}},
  \code{\link{mlflow_client_delete_experiment}},
  \code{\link{mlflow_client_delete_run}},
  \code{\link{mlflow_client_download_artifacts}},
  \code{\link{mlflow_client_get_experiment_by_name}},
  \code{\link{mlflow_client_get_experiment}},
  \code{\link{mlflow_client_get_run}},
  \code{\link{mlflow_client_list_artifacts}},
  \code{\link{mlflow_client_list_experiments}},
  \code{\link{mlflow_client_log_artifact}},
  \code{\link{mlflow_client_log_metric}},
  \code{\link{mlflow_client_log_param}},
  \code{\link{mlflow_client_restore_experiment}},
  \code{\link{mlflow_client_restore_run}},
  \code{\link{mlflow_client_set_tag}},
  \code{\link{mlflow_client_set_terminated}}
}
\concept{Tracking client functions}
\keyword{internal}
