% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rqres.R
\name{Randomized quantile residuals}
\alias{Randomized quantile residuals}
\alias{rqres.mixlink.binom}
\alias{rqres.mixlink.pois}
\title{Randomized quantile residuals for Mixture Link}
\usage{
rqres.mixlink.binom(y, m, mean, Pi, kappa)

rqres.mixlink.pois(y, mean, Pi, kappa)
}
\arguments{
\item{y}{The observations}

\item{m}{Number of success/failure trials}

\item{mean}{Estimate for parameter \eqn{\vartheta} of distribution}

\item{Pi}{Estimate for parameter \eqn{\bm{\pi}} of distribution}

\item{kappa}{Estimate for parameter \eqn{\kappa} of distribution}
}
\value{
Vector of residuals
}
\description{
Compute randomized quantile residuals for the Mixture Link Binomial
and Mixture Link Poisson distributions.
}
\examples{
n <- 400
mean.true <- rep(20, n)
Pi.true <- c(1/4, 3/4)
kappa.true <- 1.5
y <- r.mixlink.pois(n, mean.true, Pi.true, kappa.true)
r <- rqres.mixlink.pois(y, mean.true, Pi.true, kappa.true)
qqnorm(r); qqline(r)

}
\references{
Peter K. Dunn and Gordon K. Smyth. Randomized quantile
            residuals. Journal of Computational and Graphical Statistics,
            5(3):236-244, 1996.
}

