% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.eta.sq.R
\name{print.eta.sq}
\alias{print.eta.sq}
\title{Print eta.sq object}
\usage{
\method{print}{eta.sq}(x, digits = x$args$digits, check = TRUE, ...)
}
\arguments{
\item{x}{\code{eta.sq} object.}

\item{digits}{an integer value indicating the number of decimal places to be used for displaying
eta squared.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
This function prints the \code{eta.sq} object
}
\examples{
dat <- data.frame(x1 = c(1, 1, 1, 1, 2, 2, 2, 2, 2),
                  x2 = c(1, 1, 1, 2, 2, 2, 3, 3, 3),
                  y1 = c(3, 2, 4, 5, 6, 4, 7, 5, 7),
                  y2 = c(2, 4, 1, 5, 3, 3, 4, 6, 7))

# Eta squared for y1 explained by x1
dat.eta.sq <- eta.sq(dat$y1, group = dat$x1, output = FALSE)

# Print eta.sq object with 5 digits
print(dat.eta.sq, digits = 5)
}
\seealso{
\code{\link{eta.sq}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at},
}
