### BEGIN(EXPORT)

mim.cmd <- function (cmd, look.nice = TRUE, return.look.nice = FALSE, version = "R") 
{
  if (!is.character(cmd)) 
    stop("Invalid input to mim.cmd - input must be a string")
  outLines <- character(0)
  if (version == "R") {
    ##MIM <- COMCreate("mim32.server")
    MIM <- comCreateObject("mim32.Server")
    outLines <- character(0)
    for (i in 1:length(cmd)) {
      #cat("MIM cmd:", cmd[i], "\n")      
      ##NoOutputLines <- MIM$SendCmdLine(cmd[i])

      NoOutputLines <- comInvoke(MIM,"SendCmdLine",cmd[i])

      ##cat("NoOutputLines:\n"); print( NoOutputLines )
      ##if (NoOutputLines > 0) {

      if (!is.null(NoOutputLines)){
        if (NoOutputLines > 0) {
          for (i in 1:NoOutputLines){
            ##outLines <- c(outLines, MIM$GetOutputLine())
            ##outLines <- c(outLines, show(comInvoke(MIM, "GetOutputLine")))
            outLines <- c(outLines, comInvoke(MIM, "GetOutputLine"))
          }
        }
      }
      ##cat("outLines:\n"); print(outLines)
    }
    
    if (look.nice == TRUE)
      sapply(outLines, function(x) cat(x, fill = TRUE))
    if (return.look.nice == TRUE) {
      value <- outLines
    } else {
      str2 <- paste(outLines, collapse = " ")
      value <- unlist(strsplit(str2, " +"))
      value <- value[value != ""]
    }
    rm(MIM)
    return(invisible(value))
  }
  else {
    MIM <- create.ole.object("mim32.Server")
    for (i in 1:length(cmd)) {
      NoOutputLines <- call.ole.method(MIM, "SendCmdLine", cmd[i])
      for (i in 1:NoOutputLines)
        outLines <- c(outLines, 
                      call.ole.method(MIM, "GetOutputLine"))
    }
    release.ole.object(MIM)
    return(outLines)
  }
}

mcm <- function(){
  cat("Enter MIM commands here. Type quit to return to R\n")
  x <- readline("MIM->")
  while(length(which(c("stop","end","quit","exit","e","q")==x))==0){
    mim.out <- mim.cmd(x,look.nice=TRUE)
    x <- readline("MIM->")
  }
}


helpmim <- function(){
  mim.cmd("help")
}

### END(EXPORT)


.mim.cmd.file <- function(mim.cmds){
  ## Communicates with MIM by writing a file with specifications and
  ## sourcing these into MIM
  file     <- paste(getwd(),"\\","mimCMD.txt",sep='')
  write("%\n% COMMAND FILE GENERATED BY mimR", file, append=FALSE)
  lapply(mim.cmds, write, file,append=TRUE)
  mim.cmd(paste("Input",file))
} 

