mids2mplus <- function(imp, file.prefix="imp", path=getwd(), sep="\t", dec=".", silent = FALSE)
{
	m <- imp$m
	file.list <- matrix(0,m,1)
	script 	  <- matrix(0,3,1)
	for (i in 1:m){
		write.table(complete(imp,i), paste(path,"/",file.prefix,i,".dat", sep=""), sep=sep, dec=dec, col.names=F, row.names=F)
		file.list[i,] <- paste(file.prefix,i,".dat", sep="")
	}
	write.table(file.list, paste(path,"/",file.prefix,"list.dat", sep=""), sep=sep, dec=dec, col.names=F, row.names=F, quote=F)
	names <- paste(colnames(complete(imp, 1)), collapse=" ")
	script[1,] <- paste("DATA: FILE IS ",file.prefix,"list.dat;", sep="")
	script[2,] <- "TYPE = IMPUTATION;"
	script[3,] <- paste("VARIABLE: NAMES ARE ",names,";", sep="")
	write.table(script, paste(path,"/",file.prefix,"list.inp", sep=""), sep=sep, dec=dec, col.names=F, row.names=F, quote=F)

	if (!silent) {
    	cat("Data values written to", paste(path,"/",file.prefix,1,".dat", sep=""),"through", paste(file.prefix,m,".dat", sep=""), "\n")
    	cat("Data  names written to", paste(path,"/",file.prefix,"list.dat", sep=""), "\n")
    	cat("Mplus  code written to", paste(path,"/",file.prefix,"list.inp", sep=""), "\n")
    }
}

