% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/restricted.mean.R
\name{resmeanIPCW}
\alias{resmeanIPCW}
\title{Restricted IPCW mean for censored survival data}
\usage{
resmeanIPCW(
  formula,
  data,
  cause = 1,
  time = NULL,
  beta = NULL,
  offset = NULL,
  weights = NULL,
  cens.weights = NULL,
  cens.model = ~+1,
  se = TRUE,
  kaplan.meier = TRUE,
  cens.code = 0,
  no.opt = FALSE,
  method = "nr",
  model = "exp",
  augmentation = NULL,
  h = NULL,
  MCaugment = NULL,
  Ydirect = NULL,
  ...
)
}
\arguments{
\item{formula}{formula with outcome (see \code{coxph})}

\item{data}{data frame}

\item{cause}{cause of interest}

\item{time}{time of interest}

\item{beta}{starting values}

\item{offset}{offsets for partial likelihood}

\item{weights}{for score equations}

\item{cens.weights}{censoring weights}

\item{cens.model}{only stratified cox model without covariates}

\item{se}{to compute se's  based on IPCW}

\item{kaplan.meier}{uses Kaplan-Meier for IPCW in contrast to exp(-Baseline)}

\item{cens.code}{gives censoring code}

\item{no.opt}{to not optimize}

\item{method}{for optimization}

\item{model}{exp or linear}

\item{augmentation}{to augment binomial regression}

\item{h}{h for estimating equation}

\item{MCaugment}{iid of h and censoring model}

\item{Ydirect}{to bypass the construction of the response Y=min(T,tau) and use this instead}

\item{...}{Additional arguments to lower level funtions}
}
\description{
Simple and fast version for IPCW regression for just one time-point thus fitting the model 
\deqn{E( min(T, t) | X ) = exp( X^T beta) } or in the case of competing risks data
\deqn{E( I(epsilon=1) (t - min(T ,t)) | X ) = exp( X^T beta) } thus given years lost to 
cause.
}
\details{
When the status is binary assumes it is a survival setting and default is to consider outcome Y=min(T,t), 
if status has more than two levels, then computes years lost due to that particular cause, thus

Based on binomial regresion IPCW response estimating equation: 
\deqn{ X ( \Delta (min(T , t))/G_c(min(T_i,t)) - exp( X^T beta)) = 0 }
for IPCW adjusted responses. Here \deqn{ \Delta(min(T,t)) I ( min(T ,t) \leq C ) } is indicator of
being uncensored. 

Can also solve the binomial regresion IPCW response estimating equation: 
\deqn{ h(X) X ( \Delta (min(T, t))/G_c(min(T_i,t)) - exp( X^T beta)) = 0 }
for IPCW adjusted responses where $h$ is given as an argument together with iid of censoring with h. 

By using appropriately  the h argument we can also do the efficient IPCW estimator estimator.

Variance is based on  \deqn{ \sum w_i^2 } also with IPCW adjustment, and naive.var is variance 
under known censoring model. 

When Ydirect is given it solves : 
\deqn{ X ( \Delta( min(T,t)) Ydirect /G_c(min(T_i,t)) - exp( X^T beta)) = 0 }
for IPCW adjusted responses. 

Censoring model may depend on strata.
}
\examples{

data(bmt); bmt$time <- bmt$time+runif(nrow(bmt))*0.001
# E( min(T;t) | X ) = exp( a+b X) with IPCW estimation 
out <- resmeanIPCW(Event(time,cause!=0)~tcell+platelet+age,bmt,
                time=50,cens.model=~strata(platelet),model="exp")
summary(out)

 ### same as Kaplan-Meier for full censoring model 
bmt$int <- with(bmt,strata(tcell,platelet))
out <- resmeanIPCW(Event(time,cause!=0)~-1+int,bmt,time=30,
                             cens.model=~strata(platelet,tcell),model="lin")
estimate(out)
out1 <- phreg(Surv(time,cause!=0)~strata(tcell,platelet),data=bmt)
rm1 <- resmean.phreg(out1,times=30)
summary(rm1)

## competing risks years-lost for cause 1  
out <- resmeanIPCW(Event(time,cause)~-1+int,bmt,time=30,cause=1,
                            cens.model=~strata(platelet,tcell),model="lin")
estimate(out)
## same as integrated cumulative incidence 
rmc1 <- cif.yearslost(Surv(time,cause!=0)~cause+strata(tcell,platelet),data=bmt,times=30)
summary(rmc1)
}
\author{
Thomas Scheike
}
