% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/meteDist2Rank.R
\name{meteDist2Rank}
\alias{meteDist2Rank}
\title{meteDist2Rank}
\usage{
meteDist2Rank(x)
}
\arguments{
\item{x}{\code{meteDist} object}
}
\value{
A vector of predicted quantiles, typically used to compare against data as in \code{plot.meteDist}
}
\description{
\code{meteESF} calculate the rank distribution of a meteDist object
}
\details{
Extracts the predicted rank distribution from a \code{meteDist} object.
This is effectively the quantile function of the distribution. Used, e.g.,
in \code{plot.meteDist}
}
\examples{
data(arth)
esf1 <- meteESF(spp=arth$spp,
                abund=arth$count,
                power=arth$mass^(.75),
                minE=min(arth$mass^(.75)))
sad1 <- sad(esf1)
meteDist2Rank(sad1)
}
\author{
Andy Rominger <ajrominger@gmail.com>, Cory Merow
}
\references{
Harte, J. 2011. Maximum entropy and ecology: a theory of abundance, distribution, and energetics. Oxford University Press.
}

