## library("foreign")
## my.df1 <- read.spss("ZA4350_F1.sav", use.value.labels=TRUE, max.value.labels=Inf, to.data.frame=TRUE)
## my.df2 <- read.spss("ZA4350_F1.sav", use.value.labels=FALSE, max.value.labels=Inf, to.data.frame=TRUE)
## my.df3 <- cbind(V3=my.df1[, 3], my.df2[, 11:18])
## my.df4 <- my.df3[, c("V3", "V11", "V12", "V13", "V15", "V18", "V16", "V17")]
## names(my.df4) <- c("Region", "JP1", "JP2", "JP3", "JA1", "JA2", "CS1", "CS2")
## my.df5 <- split(my.df4[,-1], my.df4$Country)
## my.df6 <- lapply(my.df5, function(x){ cov(x, use="complete.obs") })
## my.names <- names(my.df6)
## my.names <- sub(pattern="-W-", replacement="-", x=my.names)
## my.names <- sub(pattern="-E-", replacement="-", x=my.names)
## my.names <- sub(pattern="-West", replacement=" West", x=my.names)
## my.names <- sub(pattern="-East", replacement=" East", x=my.names)
## my.names <- sapply( strsplit(my.names, "-"), function(x) x[2])
## my.names <- sub(pattern="^ ", replacement="", x=my.names)
## names(my.df6) <- my.names
## my.n <- unname(sapply(my.df5, function(x) { sum(complete.cases(x)) }))
## issp05 <- list(data=my.df6, n=my.n)
## dump(c("issp05"), file="issp05.R")

issp05 <-
structure(list(data = structure(list(Australia = structure(c(0.422748465124867, 
0.124011196300353, 0.136743420914588, 0.0431254799763317, 0.00794400171217786, 
0.0795176526377191, 0.084169488822584, 0.124011196300353, 0.599784419061527, 
0.24577965541821, 0.128957387993533, 0.117456840348407, 0.0404388115231489, 
0.0409603783097759, 0.136743420914588, 0.24577965541821, 0.558541075782455, 
0.120806558072865, 0.0467611601803542, 0.0814405554746228, 0.0881139125842076, 
0.0431254799763317, 0.128957387993533, 0.120806558072865, 0.58484183037569, 
0.196221518406811, 0.23316013719005, 0.183785747558078, 0.00794400171217786, 
0.117456840348407, 0.0467611601803542, 0.196221518406811, 0.879814825805686, 
0.161437510004191, 0.141503766971154, 0.0795176526377191, 0.0404388115231489, 
0.0814405554746228, 0.23316013719005, 0.161437510004191, 0.549402865979517, 
0.376621278366189, 0.084169488822584, 0.0409603783097759, 0.0881139125842076, 
0.183785747558078, 0.141503766971154, 0.376621278366189, 0.585923332080374
), .Dim = c(7L, 7L), .Dimnames = list(c("JP1", "JP2", "JP3", 
"JA1", "JA2", "CS1", "CS2"), c("JP1", "JP2", "JP3", "JA1", "JA2", 
"CS1", "CS2"))), `Germany West` = structure(c(0.382532733985565, 
0.18178159062197, 0.178430335615164, 0.111538423872061, 0.0110634505587057, 
0.0900901959632165, 0.097463544574042, 0.18178159062197, 0.601474865587449, 
0.291012721450187, 0.143176543173605, 0.146910714810353, 0.0656873402473779, 
0.119308399682698, 0.178430335615164, 0.291012721450187, 0.68043207881619, 
0.215176621519719, 0.0834630940838891, 0.178062108881511, 0.164980266572651, 
0.111538423872061, 0.143176543173605, 0.215176621519719, 0.566514871071677, 
0.193296510659968, 0.208044187208038, 0.186665491474964, 0.0110634505587057, 
0.146910714810353, 0.0834630940838891, 0.193296510659968, 1.10288999226332, 
0.116532009284014, 0.192968436309506, 0.0900901959632165, 0.0656873402473779, 
0.178062108881511, 0.208044187208038, 0.116532009284014, 0.725904163116608, 
0.424279460587008, 0.097463544574042, 0.119308399682698, 0.164980266572651, 
0.186665491474964, 0.192968436309506, 0.424279460587008, 0.703700874538492
), .Dim = c(7L, 7L), .Dimnames = list(c("JP1", "JP2", "JP3", 
"JA1", "JA2", "CS1", "CS2"), c("JP1", "JP2", "JP3", "JA1", "JA2", 
"CS1", "CS2"))), `Germany East` = structure(c(0.332257965403877, 
0.100350262697023, 0.155052693028543, 0.114600424002212, 0.00415706516729653, 
0.125713583433189, 0.14266752696101, 0.100350262697023, 0.488487418195225, 
0.264835468706793, 0.0687682428488033, 0.100159768949519, 0.100125971671736, 
0.116468491719667, 0.155052693028543, 0.264835468706793, 0.800884874181952, 
0.263649491504593, 0.179282268719083, 0.237004946692475, 0.228177712231542, 
0.114600424002212, 0.0687682428488033, 0.263649491504593, 0.666549912434326, 
0.268802040126586, 0.240246412879835, 0.201619196853781, 0.00415706516729653, 
0.100159768949519, 0.179282268719083, 0.268802040126586, 1.09109288106431, 
0.133766552984914, 0.123986849786463, 0.125713583433189, 0.100125971671736, 
0.237004946692475, 0.240246412879835, 0.133766552984914, 0.663803115494516, 
0.468946446677113, 0.14266752696101, 0.116468491719667, 0.228177712231542, 
0.201619196853781, 0.123986849786463, 0.468946446677113, 0.734838848434572
), .Dim = c(7L, 7L), .Dimnames = list(c("JP1", "JP2", "JP3", 
"JA1", "JA2", "CS1", "CS2"), c("JP1", "JP2", "JP3", "JA1", "JA2", 
"CS1", "CS2"))), `Great Britain` = structure(c(0.418466672846945, 
0.141064862025277, 0.163661506133927, 0.0440962887426223, 0.0157519854145422, 
0.0957479682333673, 0.095338524767467, 0.141064862025277, 0.569259293594141, 
0.236213343221779, 0.101993139890609, 0.139474985321838, 0.074180340533358, 
0.0601557430240104, 0.163661506133927, 0.236213343221779, 0.618513024937425, 
0.127111337721331, 0.0826643181607491, 0.120595778869627, 0.141834306727233, 
0.0440962887426223, 0.101993139890609, 0.127111337721331, 0.635601495627453, 
0.212450171502735, 0.289912240042026, 0.215758165693273, 0.0157519854145422, 
0.139474985321838, 0.0826643181607491, 0.212450171502735, 0.849442229844566, 
0.196472605914527, 0.195349340255246, 0.0957479682333673, 0.074180340533358, 
0.120595778869627, 0.289912240042026, 0.196472605914527, 0.67049225920089, 
0.479039584685269, 0.095338524767467, 0.0601557430240104, 0.141834306727233, 
0.215758165693273, 0.195349340255246, 0.479039584685269, 0.717694138005624
), .Dim = c(7L, 7L), .Dimnames = list(c("JP1", "JP2", "JP3", 
"JA1", "JA2", "CS1", "CS2"), c("JP1", "JP2", "JP3", "JA1", "JA2", 
"CS1", "CS2"))), `United States` = structure(c(0.564616487366168, 
0.15550440851239, 0.196915771199138, 0.00441871419941078, 0.00535994201823729, 
0.0717808190012695, 0.0880553665510166, 0.15550440851239, 0.742355074424418, 
0.267376564757982, 0.0672671836174907, 0.161141573615814, 0.023737393002978, 
0.0559870871704705, 0.196915771199138, 0.267376564757982, 0.686147539456607, 
0.113880582053154, 0.0789141016508302, 0.0988191627241848, 0.114626201263073, 
0.00441871419941078, 0.0672671836174907, 0.113880582053154, 0.763038577920978, 
0.280854042267428, 0.226937922432537, 0.170654982785555, 0.00535994201823729, 
0.161141573615814, 0.0789141016508302, 0.280854042267428, 1.12811964682222, 
0.149461832369188, 0.112023852717806, 0.0717808190012695, 0.023737393002978, 
0.0988191627241848, 0.226937922432537, 0.149461832369188, 0.515439773395632, 
0.312585218376386, 0.0880553665510166, 0.0559870871704705, 0.114626201263073, 
0.170654982785555, 0.112023852717806, 0.312585218376386, 0.549780394960838
), .Dim = c(7L, 7L), .Dimnames = list(c("JP1", "JP2", "JP3", 
"JA1", "JA2", "CS1", "CS2"), c("JP1", "JP2", "JP3", "JA1", "JA2", 
"CS1", "CS2"))), Hungary = structure(c(0.265529075827552, 0.112782543850304, 
0.0803478362587758, 0.035206619166087, -0.000548324633249152, 
0.0484687642956065, 0.049419193659905, 0.112782543850304, 0.408724314907537, 
0.196863165326666, 0.12128105345173, 0.138194518424752, 0.0740582916084398, 
0.0747392585815416, 0.0803478362587758, 0.196863165326666, 1.0115430168508, 
0.364330908171813, 0.36967733445296, 0.266381328971803, 0.245443683404668, 
0.035206619166087, 0.12128105345173, 0.364330908171813, 0.897470604577518, 
0.402267661797544, 0.361153758582586, 0.279363567431397, -0.000548324633249152, 
0.138194518424752, 0.36967733445296, 0.402267661797544, 1.27750866352921, 
0.279746872460735, 0.203026334204386, 0.0484687642956065, 0.0740582916084398, 
0.266381328971803, 0.361153758582586, 0.279746872460735, 0.663543827326829, 
0.434818300882959, 0.049419193659905, 0.0747392585815416, 0.245443683404668, 
0.279363567431397, 0.203026334204386, 0.434818300882959, 0.650049819209535
), .Dim = c(7L, 7L), .Dimnames = list(c("JP1", "JP2", "JP3", 
"JA1", "JA2", "CS1", "CS2"), c("JP1", "JP2", "JP3", "JA1", "JA2", 
"CS1", "CS2"))), Ireland = structure(c(0.519374251932392, 0.224970636598544, 
0.225722339675828, 0.0939740707182568, 0.0583766793069119, 0.0828752642706131, 
0.115195140776536, 0.224970636598544, 0.743766569347965, 0.299109589807264, 
0.0923610411982505, 0.124734610781122, 0.0609595400293075, 0.0663008825799523, 
0.225722339675828, 0.299109589807264, 0.685290334127543, 0.18061679922145, 
0.09279841605423, 0.148649283533004, 0.202437441972326, 0.0939740707182568, 
0.0923610411982505, 0.18061679922145, 0.661838764164346, 0.278573106480083, 
0.231520073380538, 0.226128393570254, 0.0583766793069119, 0.124734610781122, 
0.09279841605423, 0.278573106480083, 1.21218944707317, 0.198346700672282, 
0.188143897446223, 0.0828752642706131, 0.0609595400293075, 0.148649283533004, 
0.231520073380538, 0.198346700672282, 0.532344485832858, 0.392389006342495, 
0.115195140776536, 0.0663008825799523, 0.202437441972326, 0.226128393570254, 
0.188143897446223, 0.392389006342495, 0.585765741579695), .Dim = c(7L, 
7L), .Dimnames = list(c("JP1", "JP2", "JP3", "JA1", "JA2", "CS1", 
"CS2"), c("JP1", "JP2", "JP3", "JA1", "JA2", "CS1", "CS2"))), 
    Norway = structure(c(0.519829627135673, 0.108484440382858, 
    0.087676825977052, 0.0199231505084999, -0.0319769772177064, 
    0.0818703605726837, 0.0748480913215654, 0.108484440382858, 
    0.5608616709153, 0.259571449184743, 0.100596411908999, 0.10648237218027, 
    0.028119138088596, -0.0181027848588332, 0.087676825977052, 
    0.259571449184743, 0.768214344882134, 0.163730032759901, 
    0.125635290911131, 0.106372148205153, 0.0725594407836724, 
    0.0199231505084999, 0.100596411908999, 0.163730032759901, 
    0.575622999267846, 0.20306061917817, 0.118600997226364, 0.0975341894730092, 
    -0.0319769772177064, 0.10648237218027, 0.125635290911131, 
    0.20306061917817, 0.887156702419316, 0.11873527006878, 0.13330888365158, 
    0.0818703605726837, 0.028119138088596, 0.106372148205153, 
    0.118600997226364, 0.11873527006878, 0.690773652060988, 0.441483093646289, 
    0.0748480913215654, -0.0181027848588332, 0.0725594407836724, 
    0.0975341894730092, 0.13330888365158, 0.441483093646289, 
    0.743103987302198), .Dim = c(7L, 7L), .Dimnames = list(c("JP1", 
    "JP2", "JP3", "JA1", "JA2", "CS1", "CS2"), c("JP1", "JP2", 
    "JP3", "JA1", "JA2", "CS1", "CS2"))), Sweden = structure(c(0.492424270232637, 
    0.114259355105527, 0.0614635602687448, 0.00332199084525396, 
    -0.00933950501724621, 0.112732340529145, 0.116934077752939, 
    0.114259355105527, 0.569233837566272, 0.286607054366858, 
    0.127568730950554, 0.15595798752204, 0.0308877852293153, 
    0.0466008631058351, 0.0614635602687448, 0.286607054366858, 
    0.905367921192344, 0.119225823186884, 0.139261159870351, 
    0.0665652327657195, 0.118814703877858, 0.00332199084525396, 
    0.127568730950554, 0.119225823186884, 0.67757723475769, 0.227613268875699, 
    0.118858140590568, 0.13115684813424, -0.00933950501724621, 
    0.15595798752204, 0.139261159870351, 0.227613268875699, 0.69769883308189, 
    0.0905820641860021, 0.0633172678674776, 0.112732340529145, 
    0.0308877852293153, 0.0665652327657195, 0.118858140590568, 
    0.0905820641860021, 0.840053788109598, 0.536075719367023, 
    0.116934077752939, 0.0466008631058351, 0.118814703877858, 
    0.13115684813424, 0.0633172678674776, 0.536075719367023, 
    0.848958925999748), .Dim = c(7L, 7L), .Dimnames = list(c("JP1", 
    "JP2", "JP3", "JA1", "JA2", "CS1", "CS2"), c("JP1", "JP2", 
    "JP3", "JA1", "JA2", "CS1", "CS2"))), `Czech Republic` = structure(c(0.458561971286139, 
    0.146442152590744, 0.128816045895465, 0.0674571372265651, 
    0.0502981599480318, 0.10395600224806, 0.134267592166824, 
    0.146442152590744, 0.606931032720956, 0.255340238090025, 
    0.143415299948178, 0.188275781529411, 0.00557708730210865, 
    0.04418460370638, 0.128816045895465, 0.255340238090025, 1.02285868605254, 
    0.257540125687009, 0.259265584970111, 0.216346610027225, 
    0.234225988453145, 0.0674571372265651, 0.143415299948178, 
    0.257540125687009, 0.921726627106644, 0.288484529987519, 
    0.250998124183436, 0.240308889326823, 0.0502981599480318, 
    0.188275781529411, 0.259265584970111, 0.288484529987519, 
    0.958297021320079, 0.187064894494442, 0.166876145014488, 
    0.10395600224806, 0.00557708730210865, 0.216346610027225, 
    0.250998124183436, 0.187064894494442, 0.693749954381893, 
    0.454013298590583, 0.134267592166824, 0.04418460370638, 0.234225988453145, 
    0.240308889326823, 0.166876145014488, 0.454013298590583, 
    0.755103023933084), .Dim = c(7L, 7L), .Dimnames = list(c("JP1", 
    "JP2", "JP3", "JA1", "JA2", "CS1", "CS2"), c("JP1", "JP2", 
    "JP3", "JA1", "JA2", "CS1", "CS2"))), Slovenia = structure(c(0.449781327927739, 
    0.171585579028913, 0.123937615391656, 0.0937175591776412, 
    0.0648247163067526, 0.140004822171272, 0.0961386910037483, 
    0.171585579028913, 0.441706423533982, 0.23276464455463, 0.0877356110650971, 
    0.0934742181273455, 0.0747760257718265, 0.0791182124032496, 
    0.123937615391656, 0.23276464455463, 0.72827511380101, 0.164111213557445, 
    0.13389004110008, 0.153173144970989, 0.138680957558195, 0.0937175591776412, 
    0.0877356110650971, 0.164111213557445, 0.603425527592419, 
    0.240178732885199, 0.293052947887063, 0.20228338739672, 0.0648247163067526, 
    0.0934742181273455, 0.13389004110008, 0.240178732885199, 
    0.739709910678207, 0.151084653663176, 0.156726147553976, 
    0.140004822171272, 0.0747760257718265, 0.153173144970989, 
    0.293052947887063, 0.151084653663176, 0.581694502055004, 
    0.306184434656231, 0.0961386910037483, 0.0791182124032496, 
    0.138680957558195, 0.20228338739672, 0.156726147553976, 0.306184434656231, 
    0.622924066429874), .Dim = c(7L, 7L), .Dimnames = list(c("JP1", 
    "JP2", "JP3", "JA1", "JA2", "CS1", "CS2"), c("JP1", "JP2", 
    "JP3", "JA1", "JA2", "CS1", "CS2"))), Bulgaria = structure(c(0.171219409500582, 
    0.0903842258086299, 0.100616477261443, 0.0619178321608879, 
    0.0575246372436475, 0.0624103784264736, 0.0752523306574301, 
    0.0903842258086299, 0.18380217912001, 0.129639964568446, 
    0.0851469495894786, 0.0848768435728671, 0.0966085806326042, 
    0.0970276421730824, 0.100616477261443, 0.129639964568446, 
    0.596595671153869, 0.340830099343404, 0.237180887616036, 
    0.317313001235338, 0.230320989223564, 0.0619178321608879, 
    0.0851469495894786, 0.340830099343404, 1.01056988397358, 
    0.539469241677358, 0.363840748670324, 0.261760535127685, 
    0.0575246372436475, 0.0848768435728671, 0.237180887616036, 
    0.539469241677358, 0.928036607309546, 0.368170389230714, 
    0.252263130925947, 0.0624103784264736, 0.0966085806326042, 
    0.317313001235338, 0.363840748670324, 0.368170389230714, 
    0.738163994073556, 0.459923019785266, 0.0752523306574301, 
    0.0970276421730824, 0.230320989223564, 0.261760535127685, 
    0.252263130925947, 0.459923019785266, 0.557768924302789), .Dim = c(7L, 
    7L), .Dimnames = list(c("JP1", "JP2", "JP3", "JA1", "JA2", 
    "CS1", "CS2"), c("JP1", "JP2", "JP3", "JA1", "JA2", "CS1", 
    "CS2"))), Russia = structure(c(0.642356602670208, 0.202078480736637, 
    0.232088590657244, 0.0519481420542962, -0.0258367941639988, 
    0.102776263492284, 0.119798098938458, 0.202078480736637, 
    0.428298857182504, 0.206815275891804, 0.101747430395179, 
    0.0806523872297826, 0.0595950084744923, 0.0508707416915285, 
    0.232088590657244, 0.206815275891804, 1.36020755072306, 0.450826634684957, 
    0.244578307282116, 0.23302276714474, 0.18128078817734, 0.0519481420542962, 
    0.101747430395179, 0.450826634684957, 1.26488884043175, 0.54381262947141, 
    0.402637995460447, 0.30836397696524, -0.0258367941639988, 
    0.0806523872297826, 0.244578307282116, 0.54381262947141, 
    1.40751999682826, 0.271791834752357, 0.201012974398113, 0.102776263492284, 
    0.0595950084744923, 0.23302276714474, 0.402637995460447, 
    0.271791834752357, 0.944368675104816, 0.620099909803649, 
    0.119798098938458, 0.0508707416915285, 0.18128078817734, 
    0.30836397696524, 0.201012974398113, 0.620099909803649, 0.851724137931035
    ), .Dim = c(7L, 7L), .Dimnames = list(c("JP1", "JP2", "JP3", 
    "JA1", "JA2", "CS1", "CS2"), c("JP1", "JP2", "JP3", "JA1", 
    "JA2", "CS1", "CS2"))), `New Zealand` = structure(c(0.455702125609848, 
    0.15874844312325, 0.162107856292535, 0.0588399633918925, 
    0.0104140432003193, 0.0905266200119733, 0.075707217715021, 
    0.15874844312325, 0.638809410760857, 0.251859650571486, 0.115014829036009, 
    0.136061050212286, 0.0487624120063583, 0.0302732533735197, 
    0.162107856292535, 0.251859650571486, 0.520919606669281, 
    0.116989051973879, 0.0493892914404465, 0.0765797568175719, 
    0.03679390048375, 0.0588399633918925, 0.115014829036009, 
    0.116989051973879, 0.499860999291234, 0.158160786661437, 
    0.150531574492682, 0.100512651128865, 0.0104140432003193, 
    0.136061050212286, 0.0493892914404465, 0.158160786661437, 
    0.826313797540651, 0.124526743873991, 0.143934545804862, 
    0.0905266200119733, 0.0487624120063583, 0.0765797568175719, 
    0.150531574492682, 0.124526743873991, 0.517055799838979, 
    0.339039243615945, 0.075707217715021, 0.0302732533735197, 
    0.03679390048375, 0.100512651128865, 0.143934545804862, 0.339039243615945, 
    0.585848076354053), .Dim = c(7L, 7L), .Dimnames = list(c("JP1", 
    "JP2", "JP3", "JA1", "JA2", "CS1", "CS2"), c("JP1", "JP2", 
    "JP3", "JA1", "JA2", "CS1", "CS2"))), Canada = structure(c(0.553489616784414, 
    0.189052130164847, 0.194944872618283, 0.0367333012202954, 
    0.0198271248126739, 0.0613158317276814, 0.0740325947334618, 
    0.189052130164847, 0.477172982230786, 0.231441340184115, 
    0.051334029115821, 0.12442464140441, 0.0279717940483836, 
    0.0487382252194391, 0.194944872618283, 0.231441340184115, 
    0.667423999143652, 0.0450010704345964, 0.0336946050096339, 
    0.0637778312995076, 0.0743764718475701, 0.0367333012202954, 
    0.051334029115821, 0.0450010704345964, 0.558384178976664, 
    0.214614108327981, 0.175859023763648, 0.141447227574395, 
    0.0198271248126739, 0.12442464140441, 0.0336946050096339, 
    0.214614108327981, 0.840363412545494, 0.132513112823806, 
    0.129411528580604, 0.0613158317276814, 0.0279717940483836, 
    0.0637778312995076, 0.175859023763648, 0.132513112823806, 
    0.586223506743738, 0.394294583600942, 0.0740325947334618, 
    0.0487382252194391, 0.0743764718475701, 0.141447227574395, 
    0.129411528580604, 0.394294583600942, 0.639860308285164), .Dim = c(7L, 
    7L), .Dimnames = list(c("JP1", "JP2", "JP3", "JA1", "JA2", 
    "CS1", "CS2"), c("JP1", "JP2", "JP3", "JA1", "JA2", "CS1", 
    "CS2"))), Philippines = structure(c(0.437638188065151, 0.183846551947212, 
    0.173638245568638, 0.153586779948534, 0.194016762266212, 
    0.161332499532784, 0.134706947858714, 0.183846551947212, 
    0.341061083078162, 0.196424001955119, 0.131548568881988, 
    0.139057805379451, 0.114064633918431, 0.111691177527638, 
    0.173638245568638, 0.196424001955119, 0.441260907692529, 
    0.225763718175414, 0.203821106654591, 0.22634162821121, 0.209623927200587, 
    0.153586779948534, 0.131548568881988, 0.225763718175414, 
    0.654460832937997, 0.347507942669024, 0.357590460171648, 
    0.308291283909087, 0.194016762266212, 0.139057805379451, 
    0.203821106654591, 0.347507942669024, 0.970773853164848, 
    0.364198329523727, 0.402294389097339, 0.161332499532784, 
    0.114064633918431, 0.22634162821121, 0.357590460171648, 0.364198329523727, 
    0.649394775808283, 0.466290737625969, 0.134706947858714, 
    0.111691177527638, 0.209623927200587, 0.308291283909087, 
    0.402294389097339, 0.466290737625969, 0.605467862739179), .Dim = c(7L, 
    7L), .Dimnames = list(c("JP1", "JP2", "JP3", "JA1", "JA2", 
    "CS1", "CS2"), c("JP1", "JP2", "JP3", "JA1", "JA2", "CS1", 
    "CS2"))), Israel = structure(c(0.214209620077545, 0.106803640665453, 
    0.100180237095396, 0.0911110904653957, 0.0777473769618591, 
    0.0847424034090205, 0.110471093933876, 0.106803640665453, 
    0.373974940230654, 0.15589579694526, 0.153388116739133, 0.154348142504986, 
    0.0905513335067573, 0.110257410779541, 0.100180237095396, 
    0.15589579694526, 0.361914229439964, 0.179974636738638, 0.150416682150953, 
    0.157098926009885, 0.162682559738378, 0.0911110904653957, 
    0.153388116739133, 0.179974636738638, 0.689004298437945, 
    0.341986726869573, 0.278521281603429, 0.262359557521028, 
    0.0777473769618591, 0.154348142504986, 0.150416682150953, 
    0.341986726869573, 1.26280860183086, 0.253895846494977, 0.256079905112292, 
    0.0847424034090205, 0.0905513335067573, 0.157098926009885, 
    0.278521281603429, 0.253895846494977, 0.576286434526243, 
    0.429682757937245, 0.110471093933876, 0.110257410779541, 
    0.162682559738378, 0.262359557521028, 0.256079905112292, 
    0.429682757937245, 0.670344184721345), .Dim = c(7L, 7L), .Dimnames = list(
        c("JP1", "JP2", "JP3", "JA1", "JA2", "CS1", "CS2"), c("JP1", 
        "JP2", "JP3", "JA1", "JA2", "CS1", "CS2"))), Japan = structure(c(0.69551618732373, 
    0.293405164406465, 0.148460642088731, 0.0632969111512675, 
    0.0738216270075828, 0.0251633931737963, 0.0712613784135241, 
    0.293405164406465, 0.665261006873491, 0.219338658740479, 
    0.0872190228497121, 0.096284599665614, 0.0606539104588519, 
    0.0971391417425228, 0.148460642088731, 0.219338658740479, 
    1.03478796885819, 0.13714049279719, 0.105383952848192, 0.116283586374614, 
    0.139011703511053, 0.0632969111512675, 0.0872190228497121, 
    0.13714049279719, 1.00816543664398, 0.259681151098576, 0.21594075625285, 
    0.14369310793238, 0.0738216270075828, 0.096284599665614, 
    0.105383952848192, 0.259681151098576, 0.875160859946296, 
    0.171507945890261, 0.126267880364109, 0.0251633931737963, 
    0.0606539104588519, 0.116283586374614, 0.21594075625285, 
    0.171507945890261, 0.675704659449783, 0.447984395318596, 
    0.0712613784135241, 0.0971391417425228, 0.139011703511053, 
    0.14369310793238, 0.126267880364109, 0.447984395318596, 0.615474642392718
    ), .Dim = c(7L, 7L), .Dimnames = list(c("JP1", "JP2", "JP3", 
    "JA1", "JA2", "CS1", "CS2"), c("JP1", "JP2", "JP3", "JA1", 
    "JA2", "CS1", "CS2"))), Spain = structure(c(0.33914236417226, 
    0.213719380020891, 0.170441882050342, 0.155548330030929, 
    0.121847076863094, 0.148688930981207, 0.164047292755951, 
    0.213719380020891, 0.432658595416205, 0.246675773737303, 
    0.190588729927347, 0.179751170389509, 0.148361600167593, 
    0.144948630884317, 0.170441882050342, 0.246675773737303, 
    0.566501982897329, 0.35885204356264, 0.300125985993151, 0.281391025025532, 
    0.283950751987989, 0.155548330030929, 0.190588729927347, 
    0.35885204356264, 0.771144843157622, 0.418357875870336, 0.46054790813788, 
    0.440070092438222, 0.121847076863094, 0.179751170389509, 
    0.300125985993151, 0.418357875870336, 0.810791151302486, 
    0.321305744437558, 0.32898492532493, 0.148688930981207, 0.148361600167593, 
    0.281391025025532, 0.46054790813788, 0.321305744437558, 0.69820098984838, 
    0.598371638312544, 0.164047292755951, 0.144948630884317, 
    0.283950751987989, 0.440070092438222, 0.32898492532493, 0.598371638312544, 
    0.757927952305718), .Dim = c(7L, 7L), .Dimnames = list(c("JP1", 
    "JP2", "JP3", "JA1", "JA2", "CS1", "CS2"), c("JP1", "JP2", 
    "JP3", "JA1", "JA2", "CS1", "CS2"))), Latvia = structure(c(0.400248181429183, 
    0.146107545285979, 0.0905805163314791, 0.0284980744544288, 
    -0.00739409499358151, 0.107291399229782, 0.0832777064612751, 
    0.146107545285979, 0.377882375314981, 0.17910521561356, 0.0769020111253744, 
    0.0686007702182285, 0.0573384681215233, 0.0413065183283412, 
    0.0905805163314791, 0.17910521561356, 1.10685969666714, 0.366076166024818, 
    0.241745827984596, 0.18936243046641, 0.191016973327628, 0.0284980744544288, 
    0.0769020111253744, 0.366076166024818, 0.989370988446727, 
    0.572888318356868, 0.327548138639281, 0.275378690629012, 
    -0.00739409499358151, 0.0686007702182285, 0.241745827984596, 
    0.572888318356868, 0.964313222079589, 0.29216944801027, 0.272708600770218, 
    0.107291399229782, 0.0573384681215233, 0.18936243046641, 
    0.327548138639281, 0.29216944801027, 0.772349165596919, 0.541797175866495, 
    0.0832777064612751, 0.0413065183283412, 0.191016973327628, 
    0.275378690629012, 0.272708600770218, 0.541797175866495, 
    0.724869490800171), .Dim = c(7L, 7L), .Dimnames = list(c("JP1", 
    "JP2", "JP3", "JA1", "JA2", "CS1", "CS2"), c("JP1", "JP2", 
    "JP3", "JA1", "JA2", "CS1", "CS2"))), France = structure(c(0.594719467826894, 
    0.129626161709795, 0.112033924578986, -0.069065877645546, 
    0.0688307526807887, 0.0811971814134756, 0.0827572251508805, 
    0.129626161709795, 0.475516312574712, 0.266119324879238, 
    0.036941149053622, 0.0871918276388356, 0.0146021966497814, 
    0.00560918693579112, 0.112033924578986, 0.266119324879238, 
    0.723093537080559, 0.0195273363982809, -0.0121349450837555, 
    0.0236628308005381, 0.0419552409458682, -0.069065877645546, 
    0.036941149053622, 0.0195273363982809, 0.937695005467176, 
    0.286251119704616, 0.184928905909439, 0.0974364096209806, 
    0.0688307526807887, 0.0871918276388356, -0.0121349450837555, 
    0.286251119704616, 1.06662463547828, 0.193700315546026, 0.123270505029698, 
    0.0811971814134756, 0.0146021966497814, 0.0236628308005381, 
    0.184928905909439, 0.193700315546026, 0.848357922618918, 
    0.535007090162101, 0.0827572251508805, 0.00560918693579112, 
    0.0419552409458682, 0.0974364096209806, 0.123270505029698, 
    0.535007090162101, 0.764708575090695), .Dim = c(7L, 7L), .Dimnames = list(
        c("JP1", "JP2", "JP3", "JA1", "JA2", "CS1", "CS2"), c("JP1", 
        "JP2", "JP3", "JA1", "JA2", "CS1", "CS2"))), Cyprus = structure(c(0.399419300336182, 
    0.224661898521247, 0.200376067444401, 0.156289715620672, 
    0.135628302667403, 0.12675801620707, 0.132540238968812, 0.224661898521247, 
    0.511047910199653, 0.33333126884363, 0.243522250657127, 0.246407168568887, 
    0.141883706469202, 0.134658405404669, 0.200376067444401, 
    0.33333126884363, 1.24089869714184, 0.505481220162963, 0.590568337499474, 
    0.336747586405088, 0.327549046081888, 0.156289715620672, 
    0.243522250657127, 0.505481220162963, 0.782500229158357, 
    0.56068237165274, 0.31880386769759, 0.316009374434846, 0.135628302667403, 
    0.246407168568887, 0.590568337499474, 0.56068237165274, 1.23389512227147, 
    0.304742215428675, 0.315676165796691, 0.12675801620707, 0.141883706469202, 
    0.336747586405088, 0.31880386769759, 0.304742215428675, 0.651835372636263, 
    0.571416892315391, 0.132540238968812, 0.134658405404669, 
    0.327549046081888, 0.316009374434846, 0.315676165796691, 
    0.571416892315391, 0.635586187077451), .Dim = c(7L, 7L), .Dimnames = list(
        c("JP1", "JP2", "JP3", "JA1", "JA2", "CS1", "CS2"), c("JP1", 
        "JP2", "JP3", "JA1", "JA2", "CS1", "CS2"))), Portugal = structure(c(0.398004978631144, 
    0.240329206567306, 0.222794381004215, 0.172137510149091, 
    0.122112846423377, 0.18323045097017, 0.18446937300603, 0.240329206567306, 
    0.486489440483944, 0.24705469228975, 0.199687274154837, 0.228296558677362, 
    0.173445898492517, 0.170172059758869, 0.222794381004215, 
    0.24705469228975, 0.478401076791498, 0.221008013480288, 0.199490028079684, 
    0.227705457757475, 0.238893994414654, 0.172137510149091, 
    0.199687274154837, 0.221008013480288, 0.559537405376055, 
    0.323756648690401, 0.261669383712764, 0.224478142330728, 
    0.122112846423377, 0.228296558677362, 0.199490028079684, 
    0.323756648690401, 0.859328496608897, 0.183209419886228, 
    0.183936585546164, 0.18323045097017, 0.173445898492517, 0.227705457757475, 
    0.261669383712764, 0.183209419886228, 0.434646225302816, 
    0.30277495593032, 0.18446937300603, 0.170172059758869, 0.238893994414654, 
    0.224478142330728, 0.183936585546164, 0.30277495593032, 0.448390357311743
    ), .Dim = c(7L, 7L), .Dimnames = list(c("JP1", "JP2", "JP3", 
    "JA1", "JA2", "CS1", "CS2"), c("JP1", "JP2", "JP3", "JA1", 
    "JA2", "CS1", "CS2"))), Denmark = structure(c(0.825932534916441, 
    0.16015379248024, 0.104397584159775, 0.0094054196264141, 
    -0.00601100396920719, 0.101229081591801, 0.163013451837617, 
    0.16015379248024, 0.705679092839794, 0.240414421834071, 0.0700035078488117, 
    0.118024337607571, -0.0149464862412256, 0.0140723836976539, 
    0.104397584159775, 0.240414421834071, 0.898176109261865, 
    0.124736911339121, 0.107188611692575, 0.092341260309072, 
    0.12671150612539, 0.0094054196264141, 0.0700035078488117, 
    0.124736911339121, 0.531746031746032, 0.163553450846269, 
    0.142418661755678, 0.124769797421731, -0.00601100396920719, 
    0.118024337607571, 0.107188611692575, 0.163553450846269, 
    0.874021519889884, 0.103354285104225, 0.0714428697253583, 
    0.101229081591801, -0.0149464862412256, 0.092341260309072, 
    0.142418661755678, 0.103354285104225, 0.760215656444338, 
    0.450386339979182, 0.163013451837617, 0.0140723836976539, 
    0.12671150612539, 0.124769797421731, 0.0714428697253583, 
    0.450386339979182, 0.84536392024982), .Dim = c(7L, 7L), .Dimnames = list(
        c("JP1", "JP2", "JP3", "JA1", "JA2", "CS1", "CS2"), c("JP1", 
        "JP2", "JP3", "JA1", "JA2", "CS1", "CS2"))), Switzerland = structure(c(0.549403992531955, 
    0.184532529082292, 0.170131408875485, -0.00658839580640528, 
    -0.00174134712049404, 0.0763679448513572, 0.059033462587965, 
    0.184532529082292, 0.649073675140026, 0.295659198621284, 
    0.0175463162429987, 0.0382055148642826, -0.000969409737182249, 
    0.021133132270573, 0.170131408875485, 0.295659198621284, 
    0.835601572598018, 0.0401577983627747, 0.0467013140887548, 
    0.0436180525635502, 0.0490790607496769, -0.00658839580640528, 
    0.0175463162429987, 0.0401577983627747, 0.623415733160994, 
    0.161648176073532, 0.093531882809134, 0.0924583512853655, 
    -0.00174134712049404, 0.0382055148642826, 0.0467013140887548, 
    0.161648176073532, 0.926388589688353, 0.0943181818181818, 
    0.0765492603762746, 0.0763679448513572, -0.000969409737182249, 
    0.0436180525635502, 0.093531882809134, 0.0943181818181818, 
    0.611514433433865, 0.326141749246015, 0.059033462587965, 
    0.021133132270573, 0.0490790607496769, 0.0924583512853655, 
    0.0765492603762746, 0.326141749246015, 0.556049834841304), .Dim = c(7L, 
    7L), .Dimnames = list(c("JP1", "JP2", "JP3", "JA1", "JA2", 
    "CS1", "CS2"), c("JP1", "JP2", "JP3", "JA1", "JA2", "CS1", 
    "CS2"))), Flanders = structure(c(0.403074208476213, 0.126445384026367, 
    0.13050970469754, 0.0281606019242934, 0.0747098578419949, 
    0.0810054266404767, 0.0812744282052136, 0.126445384026367, 
    0.450585611079668, 0.200631221493491, 0.0817338615707294, 
    0.0940866264939907, 0.00832439990678164, 0.007081932283517, 
    0.13050970469754, 0.200631221493491, 0.56675433631854, 0.108131970569631, 
    0.0867183806638479, 0.0924260079235609, 0.096811266105137, 
    0.0281606019242934, 0.0817338615707294, 0.108131970569631, 
    0.727860305623065, 0.180185105037121, 0.189265239537903, 
    0.165578453241003, 0.0747098578419949, 0.0940866264939907, 
    0.0867183806638479, 0.180185105037121, 1.03766487998136, 
    0.161551419915438, 0.197549688717249, 0.0810054266404767, 
    0.00832439990678164, 0.0924260079235609, 0.189265239537903, 
    0.161551419915438, 0.620943503012951, 0.434950228052069, 
    0.0812744282052136, 0.007081932283517, 0.096811266105137, 
    0.165578453241003, 0.197549688717249, 0.434950228052069, 
    0.722138695608749), .Dim = c(7L, 7L), .Dimnames = list(c("JP1", 
    "JP2", "JP3", "JA1", "JA2", "CS1", "CS2"), c("JP1", "JP2", 
    "JP3", "JA1", "JA2", "CS1", "CS2"))), Finland = structure(c(0.497767551543295, 
    0.145326387317234, 0.157406476056362, 0.01531979335183, 0.0456394609712688, 
    0.0974894035534768, 0.105020075271792, 0.145326387317234, 
    0.531065679807099, 0.305936245295513, 0.0578040698177998, 
    0.131148663185276, 0.015313506732271, 0.0259427833798543, 
    0.157406476056362, 0.305936245295513, 1.03621092865944, 0.149321883303577, 
    0.165405151675175, 0.130941903253116, 0.168971760504941, 
    0.01531979335183, 0.0578040698177998, 0.149321883303577, 
    0.634237488928564, 0.156271391969332, 0.165711799006994, 
    0.159040997141684, 0.0456394609712688, 0.131148663185276, 
    0.165405151675175, 0.156271391969332, 0.715992880752606, 
    0.0962663067926226, 0.133192513055213, 0.0974894035534768, 
    0.015313506732271, 0.130941903253116, 0.165711799006994, 
    0.0962663067926226, 0.785237899654376, 0.499400675602049, 
    0.105020075271792, 0.0259427833798543, 0.168971760504941, 
    0.159040997141684, 0.133192513055213, 0.499400675602049, 
    0.964945809339402), .Dim = c(7L, 7L), .Dimnames = list(c("JP1", 
    "JP2", "JP3", "JA1", "JA2", "CS1", "CS2"), c("JP1", "JP2", 
    "JP3", "JA1", "JA2", "CS1", "CS2"))), Mexico = structure(c(0.266323747419148, 
    0.109178986828139, 0.123008097492375, 0.0995604154443544, 
    0.0943410486431774, 0.113945444936604, 0.120895270043309, 
    0.109178986828139, 0.513660039681296, 0.174269635747204, 
    0.119489517599058, 0.142251398474554, 0.0922041481733616, 
    0.108674573067776, 0.123008097492375, 0.174269635747204, 
    0.304475566443777, 0.13451780059925, 0.109278637937289, 0.13222862427725, 
    0.134637605865308, 0.0995604154443544, 0.119489517599058, 
    0.13451780059925, 0.702963556805611, 0.346312237156204, 0.269955414526221, 
    0.246518369394345, 0.0943410486431774, 0.142251398474554, 
    0.109278637937289, 0.346312237156204, 0.926456361771595, 
    0.290947648457759, 0.289339234769056, 0.113945444936604, 
    0.0922041481733616, 0.13222862427725, 0.269955414526221, 
    0.290947648457759, 0.5235590897487, 0.357066719216765, 0.120895270043309, 
    0.108674573067776, 0.134637605865308, 0.246518369394345, 
    0.289339234769056, 0.357066719216765, 0.555763193135046), .Dim = c(7L, 
    7L), .Dimnames = list(c("JP1", "JP2", "JP3", "JA1", "JA2", 
    "CS1", "CS2"), c("JP1", "JP2", "JP3", "JA1", "JA2", "CS1", 
    "CS2"))), Taiwan = structure(c(0.448530920213337, 0.188180065584283, 
    0.189924058635483, 0.10601630051568, 0.0863310525412438, 
    0.0952498266649337, 0.108598098590178, 0.188180065584283, 
    0.65722135850311, 0.318671141602182, 0.114957718018378, 0.135452693226143, 
    0.0676543406678257, 0.0637546979350597, 0.189924058635483, 
    0.318671141602182, 0.749472296052217, 0.12123582128215, 0.13367382937127, 
    0.111327984363388, 0.0942548765913201, 0.10601630051568, 
    0.114957718018378, 0.12123582128215, 0.752014015345871, 0.210796951838891, 
    0.198005027735875, 0.156427708068878, 0.0863310525412438, 
    0.135452693226143, 0.13367382937127, 0.210796951838891, 0.745602316145952, 
    0.14307083165961, 0.160620356126008, 0.0952498266649337, 
    0.0676543406678257, 0.111327984363388, 0.198005027735875, 
    0.14307083165961, 0.439276118345167, 0.295063607515971, 0.108598098590178, 
    0.0637546979350597, 0.0942548765913201, 0.156427708068878, 
    0.160620356126008, 0.295063607515971, 0.426405621716993), .Dim = c(7L, 
    7L), .Dimnames = list(c("JP1", "JP2", "JP3", "JA1", "JA2", 
    "CS1", "CS2"), c("JP1", "JP2", "JP3", "JA1", "JA2", "CS1", 
    "CS2"))), `South Africa` = structure(c(0.261940003611403, 
    0.12363820026536, 0.120223592926885, 0.0916778105479126, 
    0.0419132059572441, 0.0963104811801436, 0.110182192644777, 
    0.12363820026536, 0.459040675384627, 0.164402561478896, 0.125171737895913, 
    0.135123376504424, 0.113146159744376, 0.126579007282995, 
    0.120223592926885, 0.164402561478896, 0.403615589744663, 
    0.170737694407298, 0.13536151972009, 0.144029671074497, 0.154360245261343, 
    0.0916778105479126, 0.125171737895913, 0.170737694407298, 
    0.898686548572057, 0.47582388393266, 0.309405741083368, 0.29778068841708, 
    0.0419132059572441, 0.135123376504424, 0.13536151972009, 
    0.47582388393266, 1.43148802872374, 0.254286577881991, 0.314381102419901, 
    0.0963104811801436, 0.113146159744376, 0.144029671074497, 
    0.309405741083368, 0.254286577881991, 0.625181682337886, 
    0.414306649953026, 0.110182192644777, 0.126579007282995, 
    0.154360245261343, 0.29778068841708, 0.314381102419901, 0.414306649953026, 
    0.710805682986892), .Dim = c(7L, 7L), .Dimnames = list(c("JP1", 
    "JP2", "JP3", "JA1", "JA2", "CS1", "CS2"), c("JP1", "JP2", 
    "JP3", "JA1", "JA2", "CS1", "CS2"))), `South Korea` = structure(c(0.338714328916861, 
    0.0993982319502457, 0.137092667020218, 0.123607452632133, 
    0.104701942926267, 0.113404131293253, 0.106524340268495, 
    0.0993982319502457, 0.435670425708162, 0.12244906009353, 
    0.0815595128001718, 0.0979518848532396, 0.0578367906872778, 
    0.0546061772169652, 0.137092667020218, 0.12244906009353, 
    0.491124249981373, 0.210837522626566, 0.134315242306967, 
    0.188650558158493, 0.16216925767331, 0.123607452632133, 0.0815595128001718, 
    0.210837522626566, 0.796407799755436, 0.38649287126196, 0.293791226370852, 
    0.231448845332901, 0.104701942926267, 0.0979518848532396, 
    0.134315242306967, 0.38649287126196, 0.883453350923252, 0.264336148596824, 
    0.243453087951052, 0.113404131293253, 0.0578367906872778, 
    0.188650558158493, 0.293791226370852, 0.264336148596824, 
    0.597528937899115, 0.430191399932504, 0.106524340268495, 
    0.0546061772169652, 0.16216925767331, 0.231448845332901, 
    0.243453087951052, 0.430191399932504, 0.570678599760695), .Dim = c(7L, 
    7L), .Dimnames = list(c("JP1", "JP2", "JP3", "JA1", "JA2", 
    "CS1", "CS2"), c("JP1", "JP2", "JP3", "JA1", "JA2", "CS1", 
    "CS2"))), `Dominican republic` = structure(c(1.00946048155124, 
    0.282156905690131, 0.238066494371195, 0.226274475447895, 
    0.169041423919868, 0.175503088177318, 0.223247331610379, 
    0.282156905690131, 0.539023172280871, 0.254113627403741, 
    0.19699767839152, 0.149717464628324, 0.158107670068772, 0.178897893030794, 
    0.238066494371195, 0.254113627403741, 0.521732883612948, 
    0.215195584563494, 0.145938937316571, 0.195289324981383, 
    0.212265977484778, 0.226274475447895, 0.19699767839152, 0.215195584563494, 
    0.770618073503001, 0.350496298567611, 0.291784134215253, 
    0.279692496386175, 0.169041423919868, 0.149717464628324, 
    0.145938937316571, 0.350496298567611, 0.954490049206419, 
    0.28356125980113, 0.257246776760553, 0.175503088177318, 0.158107670068772, 
    0.195289324981383, 0.291784134215253, 0.28356125980113, 0.603814446537299, 
    0.310120460817381, 0.223247331610379, 0.178897893030794, 
    0.212265977484778, 0.279692496386175, 0.257246776760553, 
    0.310120460817381, 0.606502839955028), .Dim = c(7L, 7L), .Dimnames = list(
        c("JP1", "JP2", "JP3", "JA1", "JA2", "CS1", "CS2"), c("JP1", 
        "JP2", "JP3", "JA1", "JA2", "CS1", "CS2")))), .Names = c("Australia", 
"Germany West", "Germany East", "Great Britain", "United States", 
"Hungary", "Ireland", "Norway", "Sweden", "Czech Republic", "Slovenia", 
"Bulgaria", "Russia", "New Zealand", "Canada", "Philippines", 
"Israel", "Japan", "Spain", "Latvia", "France", "Cyprus", "Portugal", 
"Denmark", "Switzerland", "Flanders", "Finland", "Mexico", "Taiwan", 
"South Africa", "South Korea", "Dominican republic")), n = c(1827L, 
1011L, 571L, 805L, 1502L, 979L, 946L, 1224L, 1279L, 1171L, 947L, 
1004L, 1421L, 1206L, 865L, 1180L, 1137L, 770L, 1173L, 1026L, 
1387L, 899L, 1772L, 1449L, 1056L, 1226L, 1197L, 1337L, 2102L, 
2765L, 1511L, 1851L)), .Names = c("data", "n"))
