% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_roc.r
\name{lines.predict_roc}
\alias{lines.predict_roc}
\title{Lines of predicted ROC curve}
\usage{
\method{lines}{predict_roc}(x, thr = seq(-10, 10, length = 1000), ...)
}
\arguments{
\item{x}{A 'predict_roc' object to plot.}

\item{thr}{The sequence of thresholds parametrising the ROC curve, if this is a function. Default to a length 1000 sequence from -10 to 10.}

\item{...}{Addtional arguments passed to \code{lines}.}
}
\value{
Invisible.
}
\description{
Plot lines method for objects of class 'predict_roc'.
}
\examples{
## Declare simulated data as metaSDTdata
metadata <- metaSDTdata(simMetaData, type1='resp', type2='conf', signal='S')

## Fit model to subset of data
fit <- metaSDTreg(A ~ signal,
            data=metadata,
            subset = m <= 20)

## Plot observed type 1 ROC points
plot(predict_roc(metadata, type = '1'), xlim = 0:1, ylim = 0:1)

## Add Model-predicted ROC curve (estimated from subset of data)
lines(predict_roc(fit, type = '1'))

}
