% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blup.meta.R
\name{blup.meta}
\alias{blup.meta}
\alias{blup}
\alias{print.blup.meta}
\alias{estimates.blup.meta}
\alias{print.estimates.blup.meta}
\title{Calculate best linear unbiased predictor for \code{meta} object}
\usage{
\method{blup}{meta}(x, level = x$level, backtransf = x$backtransf, ...)

\method{print}{blup.meta}(
  x,
  backtransf = attr(x, "x")$backtransf,
  digits = gs("digits"),
  digits.se = gs("digits.se"),
  digits.tau2 = gs("digits.tau2"),
  digits.tau = gs("digits.tau"),
  big.mark = gs("big.mark"),
  se = FALSE,
  print.tau2 = gs("print.tau2"),
  print.tau = gs("print.tau"),
  details = gs("details"),
  ...
)

\method{estimates}{blup.meta}(
  x,
  se = FALSE,
  backtransf = attr(x, "x")$backtransf,
  digits = gs("digits"),
  digits.se = gs("digits.se"),
  digits.tau2 = gs("digits.tau2"),
  digits.tau = gs("digits.tau"),
  writexl = !missing(path),
  path = "estimates_blup.xlsx",
  overwrite = FALSE,
  ...
)

\method{print}{estimates.blup.meta}(x, big.mark = gs("big.mark"), details = gs("details"), ...)
}
\arguments{
\item{x}{An object of class \code{meta}, \code{blup.meta}, or
\code{estimates.blup.meta}.}

\item{level}{The level used to calculate prediction intervals for BLUPs.}

\item{backtransf}{A logical indicating whether BLUPs should be
back transformed. If \code{backtransf = TRUE}, results for
\code{sm = "OR"} will be odds ratios rather than log odds ratios,
 for example.}

\item{\dots}{Additional arguments (passed on to \code{\link{prmatrix}}).}

\item{digits}{Minimal number of significant digits, see
\code{print.default}.}

\item{digits.se}{Minimal number of significant digits for standard errors.}

\item{digits.tau2}{Minimal number of significant digits for
between-study variance \eqn{\tau^2}, see \code{print.default}.}

\item{digits.tau}{Minimal number of significant digits for
\eqn{\tau}, the square root of the between-study variance
\eqn{\tau^2}.}

\item{big.mark}{A character used as thousands separator.}

\item{se}{A logical indicating whether standard errors should be
printed / extracted.}

\item{print.tau2}{A logical specifying whether between-study
variance \eqn{\tau^2} should be printed.}

\item{print.tau}{A logical specifying whether \eqn{\tau}, the
square root of the between-study variance \eqn{\tau^2}, should be
printed.}

\item{details}{A logical specifying whether details on
statistical methods should be printed.}

\item{writexl}{A logical indicating whether an Excel file should be
created (R package \bold{writexl} must be available).}

\item{path}{A character string specifying the filename of the Excel
file.}

\item{overwrite}{A logical indicating whether an existing Excel
file should be overwritten.}
}
\value{
Data frame with variables
\item{studlab}{Study label}
\item{blup}{estimated best linear unbiased predictor}
\item{se.blup}{standard error (only if argument \code{backtransf = FALSE})}
\item{lower}{lower prediction limits}
\item{upper}{upper prediction limits}
}
\description{
Calculate best linear unbiased predictors (BLUPs) for meta-analysis object
created with R package \bold{meta}.
}
\examples{
data("dat.bcg", package = "metadat")
m1 <- metabin(tpos, tpos + tneg, cpos, cpos + cneg,
  data = dat.bcg, studlab = paste(author, year), method = "Inverse")
summary(m1)
blup(m1)

\dontrun{
estimates(blup(m1), path = "blup_m1.xlsx")
}

}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
