% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessors.r
\docType{methods}
\name{Accessors}
\alias{Accessors}
\alias{mu.size}
\alias{mu.unit}
\alias{mu.prefix}
\alias{mu.names}
\alias{mu.size,memuse-method}
\alias{mu.unit,memuse-method}
\alias{mu.prefix,memuse-method}
\alias{mu.names,memuse-method}
\title{Accessors}
\usage{
mu.size(x, as.is = TRUE)

mu.unit(x)

mu.prefix(x)

mu.names(x)

\S4method{mu.size}{memuse}(x, as.is = TRUE)

\S4method{mu.unit}{memuse}(x)

\S4method{mu.prefix}{memuse}(x)

\S4method{mu.names}{memuse}(x)
}
\arguments{
\item{x}{memuse object}

\item{as.is}{logical; should the size be "as-is", or converted to bytes first.}

\item{...}{Additional arguments; in this case, they are ignored.}
}
\value{
Returns a numeric value in the case of \code{size()}, and
\code{as.numeric()}, otherwise a string is returned.
}
\description{
Accessor methods for slots of objects of class \code{memuse}.
}
\details{
These methods are mostly just syntactic sugar for ordinary S4 slot
accessing.  So for example, \code{size(x)} is no different semantically from
calling \code{x@size}.

There are two differences, however.  The \code{size()} method has a
parameter \code{as.is} which controls whether the return should be the raw
value or the raw value converted to bytes first.  For the latter, you should
really use \code{as.numeric} instead, which is equivalent to calling
\code{size(x, as.is=FALSE)}.
}
\examples{
\dontrun{
x <- mu(1e6)

size(x)
as.numeric(x)
mu.unit(x)
mu.prefix(x)
mu.names(x)
}

}
\seealso{
\code{ \link{memuse-class} }
}
\keyword{Methods}
