% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_entities.R
\name{extract_entities}
\alias{extract_entities}
\title{Extract Medication Entities From Phrase}
\usage{
extract_entities(
  phrase,
  p_start,
  p_stop,
  unit,
  freq_fun = NULL,
  intaketime_fun = NULL,
  strength_sep = NULL,
  ...
)
}
\arguments{
\item{phrase}{Text to search.}

\item{p_start}{Start position of phrase within original text.}

\item{p_stop}{End position of phrase within original text.}

\item{unit}{Unit of measurement for medication strength, e.g. \sQuote{mg}.}

\item{freq_fun}{Function used to extract frequency.}

\item{intaketime_fun}{Function used to extract intaketime.}

\item{strength_sep}{Delimiter for contiguous medication strengths.}

\item{\dots}{Parameter settings used in extracting frequency and intake time,
including additional arguments to \code{freq_fun} and
\code{intaketime_fun}. Use \code{freq_dict} to identify custom frequency
dictionaries and \code{intaketime_dict } to identify custom intake time
dictionaries.}
}
\value{
data.frame with entities information. At least one row per entity is returned,
using \code{NA} when no expression was found for a given entity.\cr
Sample output for the phrase \dQuote{Lamotrigine 200mg bid} would look like:\cr
\tabular{rr}{
 entity   \tab  expr\cr
 IntakeTime  \tab  <NA>\cr
   Strength  \tab   <NA>\cr
    DoseAmt   \tab  <NA>\cr
  Frequency \tab  bid;19:22\cr
       Dose  \tab  200mg;13:18
}
}
\description{
This function searches a phrase for medication dosing entities of interest. It
is called within \code{\link{medExtractR}} and generally not intended for use outside
that function.
}
\details{
Various medication dosing entities are extracted within this function
including the following:

\emph{strength}: The strength of an individual unit (i.e. tablet, capsule) of
  the drug.\cr
\emph{dose amount}: The number of tablets, capsules, etc taken with each dose.\cr
\emph{dose}: The total strength given intake. This quantity would be
  equivalent to strength x dose amount, and appears similar to strength when
  dose amount is absent.\cr
\emph{frequency}: The number of times per day a dose is taken, e.g.
  \dQuote{once daily} or \sQuote{2x/day}.\cr
\emph{intaketime}: The time period of the day during which a dose is taken,
  e.g. \sQuote{morning}, \sQuote{lunch}, \sQuote{in the pm}.\cr

Strength, dose amount, and dose are primarily numeric quantities, and are
identified using a combination of regular expressions and rule-based
approaches. Frequency and intake time, on the other hand, use dictionaries
for identification.

By default and when \code{freq_fun} and/or \code{intaketime_fun} are \code{NULL}, the
\code{\link{extract_generic}} function will be used for these entities.

The \code{stength_sep} argument is \code{NULL} by default, but can be used to
identify shorthand for morning and evening doses. For example, consider the
phrase \dQuote{Lamotrigine 300-200} (meaning 300 mg in the morning and 200 mg
in the evening). The argument \code{strength_sep = '-'} identifies
the full expression \emph{300-200} as \emph{dose} in this phrase.
}
\examples{
note <- "Lamotrigine 25 mg tablet - 3 tablets oral twice daily"
extract_entities(note, 1, nchar(note), "mg")
# A user-defined dictionary can be used instead of the default
my_dictionary <- data.frame(c("daily", "twice daily"))
extract_entities(note, 1, 53, "mg", freq_dict = my_dictionary)
}
