% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ccfs.R
\name{ccf_rs}
\alias{ccf_rs}
\title{Calculate regime-switching cross-correlation}
\usage{
ccf_rs(x, y, label, lag_max)
}
\arguments{
\item{x, y}{A univariate numeric time series.}

\item{label}{A factor of regime labels.}

\item{lag_max}{Maximum lag at which to calculate the ccf.}
}
\value{
Cross-correlations for each group in \code{label}.
}
\description{
Calculate regime-switching cross-correlation
}
\examples{
set.seed(123)
x <- rnorm(100)
y <- rnorm(100)
label <- sample(1:2, 100, replace = TRUE)
ccf_rs(x, y, label = factor(label), lag_max = 3)
}
