% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wind.R
\docType{data}
\name{wind}
\alias{wind}
\title{Ireland wind data, 1961-1978}
\format{
\code{wind}: a list containing a data.frame with 6574 rows and 12 columns,
and a list of locations.
}
\usage{
wind
}
\description{
Daily average wind speeds for 1961-1978 at 11 synoptic meteorological
stations in the Republic of Ireland (Haslett and raftery 1989). Wind speeds
are in m/s. De-trended data sets are also provided.
}
\details{
The data were obtained from the \strong{gstat} package, and were modified so that
the first column is the time stamps. Locations of the 11 stations are given
in \code{wind_loc}. \code{wind_train} and \code{wind_test} contain de-trended and
square-root transformed train (1961-1970) and test (1971-1978) data sets.
See Gneiting et al. (2006) for de-trending details. \code{wind_trend} contains
the estimated annual trend and station-wise mean from the training dataset.
}
\references{
Haslett, J. and Raftery, A. E. (1989). Space-time Modelling with Long-memory
Dependence: Assessing Ireland's Wind Power Resource (with Discussion).
Applied Statistics 38, 1-50.

Gneiting, T., Genton, M., & Guttorp, P. (2006). Geostatistical Space-Time
Models, Stationarity, Separability, and Full Symmetry. In C&H/CRC
Monographs on Statistics & Applied Probability (pp. 151–175).
Chapman and Hall/CRC.
}
\seealso{
Other (simulated) datasets: 
\code{\link{sim1}},
\code{\link{sim2}},
\code{\link{sim3}}
}
\concept{(simulated) datasets}
\keyword{datasets}
