% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acfs.R
\name{acfs.mcgf}
\alias{acfs.mcgf}
\alias{acfs.mcgf_rs}
\alias{acfs<-}
\alias{add_acfs}
\title{Extract, calculate, or assign mean auto-correlations for an \code{mcgf} or
\code{mcgf_rs} object}
\usage{
\method{acfs}{mcgf}(x, lag_max, replace = FALSE, ...)

\method{acfs}{mcgf_rs}(x, lag_max, replace = FALSE, ...)

acfs(x) <- value

add_acfs(x, lag_max, ...)
}
\arguments{
\item{x}{An \code{mcgf} or \code{mcgf_rs} object.}

\item{lag_max}{Maximum lag at which to calculate the acf.}

\item{replace}{Logical; if TRUE, \code{acfs} are recalculated.}

\item{...}{Additional parameters or attributes.}

\item{value}{A Vector of mean of auto-correlations for time lags starting
from 0.}
}
\value{
\code{\link[=acfs]{acfs()}} returns (regime-switching) mean auto-correlations.
\code{\link[=add_acfs]{add_acfs()}} returns the same object with additional attributes of
(regime-switching) mean auto-correlations.
}
\description{
Extract, calculate, or assign mean auto-correlations for an \code{mcgf} or
\code{mcgf_rs} object
}
\details{
For \code{mcgf} objects, \code{\link[=acfs]{acfs()}} computes mean auto-correlations for each time
lag across locations. The output is a vector of acfs.

For \code{mcgf_rs} objects, \code{\link[=acfs]{acfs()}} computes regime-switching mean
auto-correlations for each time lag across locations. The output is a list of
vectors of acfs, where each vector in the list corresponds to the acfs for
a regime.

\code{\link{acfs<-}} assigns \code{acfs} to \code{x}.

\code{\link[=add_acfs]{add_acfs()}} adds \code{acfs} to \code{x}.
}
\examples{
# Calculate acfs for 'sim1'
data(sim1)
sim1_mcgf <- mcgf(sim1$data, dists = sim1$dists)
acfs(sim1_mcgf, lag_max = 5)

# Add acfs to 'sim1_mcgf'
sim1_mcgf <- add_acfs(sim1_mcgf, lag_max = 5)
print(sim1_mcgf, "acfs")

# Calculate acfs for 'sim2'
data(sim2)
sim2_mcgf <- mcgf_rs(sim2$data, dists = sim2$dists, label = sim2$label)
acfs(sim2_mcgf, lag_max = 5)

# Add acfs to 'sim2_mcgf'
sim2_mcgf <- add_acfs(sim2_mcgf, lag_max = 5)
print(sim2_mcgf, "acfs")
}
\concept{functions related to calculating acfs and ccfs}
