% Generated by roxygen2 (4.0.2): do not edit by hand
\name{matrixpls.sim}
\alias{matrixpls.sim}
\title{Monte Carlo simulations with matrixpls}
\usage{
matrixpls.sim(nRep = NULL, model = NULL, n = NULL, ..., cilevel = 0.95,
  citype = c("norm", "basic", "stud", "perc", "bca"), boot.R = 500,
  fitIndices = fitSummary)
}
\arguments{
\item{nRep}{Number of replications. If any of the \code{n}, \code{pmMCAR}, or \code{pmMAR} arguments are specified as lists, the number of replications will default to the length of the list(s), and \code{nRep} need not be specified.}

\item{model}{There are two options for this argument: 1. lavaan script or lavaan parameter
table, or 2. a list containing three matrices
\code{inner}, \code{reflective}, and \code{formative} defining the free regression paths
in the model.}

\item{n}{
	Sample size. Either a single value, or a list of values to vary sample size across replications. The \code{n} argument can also be specified as a random distribution object; if any resulting values are non-integers, the decimal will be rounded. 
}

\item{...}{All other arguments are passed through to \code{\link[simsem]{sim}},
\code{\link{matrixpls.boot}}, or \code{\link{matrixpls}}.}

\item{cilevel}{Confidence level. This argument will be forwarded to the \code{\link[boot]{boot.ci}} when calculating the confidence intervals.}

\item{citype}{Type of confidence interval. This argument will be forwarded to the \code{\link[boot]{boot.ci}} when calculating the confidence intervals.}

\item{boot.R}{Number of bootstrap replications to use to estimate standard errors or \code{FALSE} to disable bootstrapping.}

\item{fitIndices}{A function that returns a list of fit indices for the model. Setting this argument to \code{NULL} disables fit indices.}
}
\value{
An object of class \code{\link[simsem]{SimResult-class}}.
}
\description{
Performs Monte Carlo simulations of \code{\link{matrixpls}} with the \code{\link[simsem]{sim}} function of the \code{simsem} package.
The standard errors and confidence intervals are estimated with the \code{\link[boot]{boot}} and \code{\link[boot]{boot.ci}} functions
of the \code{boot} package.
}
\details{
This funtion calls the \code{\link[simsem]{sim}} function from the \code{simsem} package to perform Monte
Carlo simulations with matrixpls. The function parses the model parameters and replaces it with
a function call that estimates the model and bootstrapped standard errors and confidence
intervals with \link{matrixpls.boot}.

If the \code{generate} or \code{rawdata} arguments are not specified in the \code{\link[simsem]{sim}} arguments
 then the \code{model} argument will be used for data generation and must be specified in lavaan format.
}
\examples{

#
# Runs the second model from
#
# Aguirre-Urreta, M., & Marakas, G. (2013). Partial Least Squares and Models with Formatively 
# Specified Endogenous Constructs: A Cautionary Note. Information Systems Research. 
# doi:10.1287/isre.2013.0493

if(require(simsem)){
  
  library(MASS)
  
  X <- diag(15) 
  X[upper.tri(X, diag=TRUE)] <- c(
    1.000,
    0.640, 1.000,
    0.640, 0.640, 1.000,
    0.640, 0.640, 0.640, 1.000,
    0.096, 0.096, 0.096, 0.096, 1.000,
    0.096, 0.096, 0.096, 0.096, 0.640, 1.000,
    0.096, 0.096, 0.096, 0.096, 0.640, 0.640, 1.000,
    0.096, 0.096, 0.096, 0.096, 0.640, 0.640, 0.640, 1.000,
    0.115, 0.115, 0.115, 0.115, 0.192, 0.192, 0.192, 0.192, 1.000,
    0.115, 0.115, 0.115, 0.115, 0.192, 0.192, 0.192, 0.192, 0.640, 1.000,
    0.115, 0.115, 0.115, 0.115, 0.192, 0.192, 0.192, 0.192, 0.640, 0.640,
    1.000,
    0.115, 0.115, 0.115, 0.115, 0.192, 0.192, 0.192, 0.192, 0.640, 0.640,
    0.640, 1.000,
    0.000, 0.000, 0.000, 0.000, 0.271, 0.271, 0.271, 0.271, 0.325, 0.325,
    0.325, 0.325, 1.000,
    0.000, 0.000, 0.000, 0.000, 0.271, 0.271, 0.271, 0.271, 0.325, 0.325,
    0.325, 0.325, 0.300, 1.000,
    0.000, 0.000, 0.000, 0.000, 0.271, 0.271, 0.271, 0.271, 0.325, 0.325,
    0.325, 0.325, 0.300, 0.300, 1.000
  )
  X <- X + t(X) - diag(diag(X)) 
  
  colnames(X) <- rownames(X) <- c(paste("Y",1:12,sep=""),paste("X",1:3,sep=""))
  
  # Print the population covariance matrix X to see that it is correct
  
  X
  
  # The estimated model in Lavaan syntax
  
  analyzeModel <- "
ksi =~ Y1 + Y2 + Y3 + Y4
eta1 <~ X1 + X2 + X3
eta2 =~ Y5 + Y6 + Y7 + Y8
eta3 =~ Y9 + Y10 + Y11 + Y12

eta1 ~ ksi
eta2 ~ eta1
eta3 ~ eta1
"
  
  # Only run 100 replications without bootstrap replications each so that the 
  # example runs faster. Generate the data outside simsem because simsem
  # does not support drawing samples from population matrix
  
  dataSets <- lapply(1:100, function(x){
    mvrnorm(300,                 # Sample size
            rep(0,15),           # Means
            X)                   # Population covarancematrix
  })
  
  Output <- matrixpls.sim(model = analyzeModel, rawData = dataSets, boot.R=FALSE,
                          multicore = FALSE, stopOnError = TRUE)
  
  summary(Output)
  
  
} else{
  print("This example requires the simsem package")
}

}
\seealso{
\code{\link{matrixpls}}, \code{\link{matrixpls.boot}}, \code{\link[simsem]{sim}}, \code{\link[simsem]{SimResult-class}}
}

