% Generated by roxygen2 (4.0.2): do not edit by hand
\name{weight.optim}
\alias{weight.optim}
\title{Optimized weights}
\usage{
weight.optim(S, model, W.mod, parameterEstimator = params.regression,
  optimCriterion = optim.maximizeInnerR2, method = "BFGS", ...,
  validateInput = TRUE, standardize = TRUE)
}
\arguments{
\item{S}{Covariance matrix of the data.}

\item{model}{There are two options for this argument: 1. lavaan script or lavaan parameter
table, or 2. a list containing three matrices
\code{inner}, \code{reflective}, and \code{formative} defining the free regression paths
in the model.}

\item{W.mod}{An optional numeric matrix representing the weight patter and starting weights
(i.e. the how the indicators are combined to form the composite variables). If this argument is not specified,
the weight patter is defined based on the relationships in the \code{reflective} and  \code{formative}
elements of \code{model}.}

\item{parameterEstimator}{A function that takes three  or more arguments, the data covariance matrix \code{S},
model specification \code{model}, and weights \code{W} and returns a named vector of parameter estimates. The default is \code{\link{params.regression}}}

\item{optimCriterion}{A function that taking an object of class class
\code{matrixpls} and returning a scalar. The default is \code{\link{optim.maximizeInnerR2}}}

\item{method}{The minimization algorithm to be used. See \code{\link[stats]{optim}}
for details. Default is "BFGS".}

\item{...}{All other arguments are passed through to \code{\link[stats]{optim}} and \code{parameterEstimator}.}

\item{validateInput}{A boolean indicating whether the arguments should be validated.}

\item{standardize}{\code{TRUE} (default) or \code{FALSE} indicating whether S should be converted
to a correlation matrix.}
}
\value{
An object of class \code{"matrixplsweights"}, which is a matrix containing the weights with the following attributes:

\item{iterations}{Number of iterations performed}

\item{converged}{A boolean indicating if the algorithm converged}

\item{history}{A data.frame containing the weights for each iteration}
}
\description{
Calculates a set of weights to minimize an optimization criterion
}
\details{
\code{weight.optim} calculates indicator weights by optimizing the indicator
weights against the criterion function using \code{\link[stats]{optim}}. The
algoritmh works by first estimating the model with the starting weights. The
resulting \code{matrixpls} object is passed to the \code{optimCriterion}
function, which evaluates the optimization criterion for the weights. The
weights are adjusted and new estimates are calculated until the optimization
criterion converges.


Model can be specified in the lavaan format or the native matrixpls format.
The native model format is a list of three binary matrices, \code{inner}, \code{reflective},
and \code{formative} specifying the free parameters of a model: \code{inner} (\code{l x l}) specifies the
regressions between composites, \code{reflective} (\code{k x l}) specifies the regressions of observed
data on composites, and \code{formative} (\code{l x k}) specifies the regressions of composites on the
observed data. Here \code{k} is the number of observed variables and \code{l} is the number of composites.

If the model is specified in lavaan format, the native
format model is derived from this model by assigning all regressions between latent
variables to \code{inner}, all factor loadings to \code{reflective}, and all regressions
of latent variables on observed variables to \code{formative}. Regressions between
observed variables and all free covariances are ignored. All parameters that are
specified in the model will be treated as free parameters. If model is specified in
lavaan syntax, the model that is passed to the \code{parameterEstimator} will be that
model and not the native format model.

The original papers about Partial Least Squares, as well as many of the current PLS
implementations, impose restrictions on the matrices \code{inner},
\code{reflective}, and \code{formative}: \code{inner} must be a lower triangular matrix,
\code{reflective} must have exactly one non-zero value on each row and must have at least
one non-zero value on each column, and \code{formative} must only contain zeros.
Some PLS implementations allow \code{formative} to contain non-zero values, but impose a
restriction that the sum of \code{reflective} and \code{t(formative)} must satisfy
the original restrictions of \code{reflective}. The only restrictions that matrixpls
imposes on \code{inner}, \code{reflective}, and \code{formative} is that these must be
binary matrices and that the diagonal of \code{inner} must be zeros.


The argument \code{W.mod} is a (\code{l x k}) matrix that indicates
how the indicators are combined to form the composites. The original papers about
Partial Least Squares as well as all current PLS implementations define this as
\code{t(reflective) | formative}, which means that the weight patter must match the
model specified in \code{reflective} and \code{formative}. Matrixpls does not
require that \code{W.mod} needs to match \code{reflective} and \code{formative}, but
accepts any numeric matrix. If this argument is not specified, \code{W.mod} is
defined as \code{t(reflective) | formative}.
}
\examples{
library(plspm)

# Run the customer satisfaction examle form plspm

# load dataset satisfaction
data(satisfaction)
# inner model matrix
IMAG = c(0,0,0,0,0,0)
EXPE = c(1,0,0,0,0,0)
QUAL = c(0,1,0,0,0,0)
VAL = c(0,1,1,0,0,0)
SAT = c(1,1,1,1,0,0)
LOY = c(1,0,0,0,1,0)
inner = rbind(IMAG, EXPE, QUAL, VAL, SAT, LOY)
colnames(inner) <- rownames(inner)

# Reflective model
list(1:5, 6:10, 11:15, 16:19, 20:23, 24:27)

reflective<- matrix(
  c(1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1),
  27,6, dimnames = list(colnames(satisfaction)[1:27],colnames(inner)))

# empty formative model

formative <- matrix(0, 6, 27, dimnames = list(colnames(inner), colnames(satisfaction)[1:27]))

# Estimation using covariance matrix
model <- list(inner = inner,
              reflective = reflective,
              formative = formative)

S <- cov(satisfaction[,1:27])

matrixpls.ModeA <- matrixpls(S, model)
matrixpls.ModeB <- matrixpls(S, model, outerEstimators = outer.modeB)
matrixpls.MaxR2 <- matrixpls(S, model, weightFunction = weight.optim)

# Compare the R2s from the different estimations

R2s <- cbind(R2(matrixpls.ModeA), R2(matrixpls.ModeB), R2(matrixpls.MaxR2))
print(R2s)
apply(R2s,2,mean)



}
\seealso{
Optimization criteria: \code{\link{optim.maximizeInnerR2}}

Other Weight algorithms: \code{\link{weight.fixed}};
  \code{\link{weight.pls}}
}

