/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.scheduling;

import choco.cp.solver.constraints.global.scheduling.AbstractResourceSConstraint;
import choco.cp.solver.constraints.global.scheduling.BoundHRTask;
import choco.kernel.memory.IEnvironment;
import choco.kernel.solver.ContradictionException;

public final class EnumHRTask
extends BoundHRTask {
    public EnumHRTask(IEnvironment env, AbstractResourceSConstraint constraint, int taskIdx) {
        super(env, constraint, taskIdx);
    }

    @Override
    protected boolean setHEST(int val) throws ContradictionException {
        if (val > this.htask.getEST()) {
            if (this.taskvar.start().canBeInstantiatedTo(val)) {
                this.estH.set(val);
                this.checkHConsistency();
                this.fireHypotheticalDomain();
            } else if (val < this.taskvar.start().getSup()) {
                int newEST = this.taskvar.start().getNextDomainValue(val);
                assert (newEST > val);
                this.estH.set(newEST);
                this.checkHConsistency();
                this.fireHypotheticalDomain();
            } else {
                this.remove();
                this.fireRemoval();
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean setHDuration(int duration) throws ContradictionException {
        if (this.taskvar.duration().canBeInstantiatedTo(duration)) {
            return super.setHDuration(duration);
        }
        this.remove();
        this.fireRemoval();
        return true;
    }

    @Override
    protected boolean setHECT(int val) throws ContradictionException {
        if (val > this.htask.getECT()) {
            if (this.taskvar.end().canBeInstantiatedTo(val)) {
                this.estH.set(val - this.htask.getMinDuration());
                this.checkHConsistency();
                this.fireHypotheticalDomain();
            } else if (val < this.taskvar.end().getSup()) {
                int newECT = this.taskvar.end().getNextDomainValue(val);
                assert (newECT > val);
                this.estH.set(newECT - this.htask.getMinDuration());
                this.checkHConsistency();
                this.fireHypotheticalDomain();
            } else {
                this.remove();
                this.fireRemoval();
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean setHLCT(int val) throws ContradictionException {
        if (val < this.htask.getLCT()) {
            if (this.taskvar.end().canBeInstantiatedTo(val)) {
                this.lctH.set(val);
                this.checkHConsistency();
                this.fireHypotheticalDomain();
            } else if (val > this.taskvar.end().getInf()) {
                int newLCT = this.taskvar.end().getPrevDomainValue(val);
                assert (newLCT < val);
                this.lctH.set(newLCT);
                this.checkHConsistency();
                this.fireHypotheticalDomain();
            } else {
                this.remove();
                this.fireRemoval();
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean setHLST(int val) throws ContradictionException {
        if (val < this.htask.getLST()) {
            if (this.taskvar.start().canBeInstantiatedTo(val)) {
                this.lctH.set(val + this.htask.getMaxDuration());
                this.checkHConsistency();
                this.fireHypotheticalDomain();
            } else if (val > this.taskvar.start().getInf()) {
                int newLST = this.taskvar.start().getPrevDomainValue(val);
                assert (newLST < val);
                this.lctH.set(newLST + this.htask.getMaxDuration());
                this.checkHConsistency();
                this.fireHypotheticalDomain();
            } else {
                this.remove();
                this.fireRemoval();
            }
            return true;
        }
        return false;
    }
}

