/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.geost.dataStructures;

import choco.cp.solver.constraints.global.geost.dataStructures.Heapable;
import choco.cp.solver.constraints.global.geost.geometricPrim.Point;
import choco.cp.solver.constraints.global.geost.internalConstraints.InternalConstraint;

public final class HeapKey
implements Heapable {
    private Point p;
    private int d;
    private InternalConstraint ictr;
    private int k;

    public HeapKey(Point p, int d, int dim, InternalConstraint ictr) {
        this.p = p;
        this.d = d;
        this.ictr = ictr;
        this.k = dim;
    }

    public int getD() {
        return this.d;
    }

    public InternalConstraint getIctr() {
        return this.ictr;
    }

    public Point getP() {
        return this.p;
    }

    public void setD(int d) {
        this.d = d;
    }

    public void setIctr(InternalConstraint ictr) {
        this.ictr = ictr;
    }

    public void setP(Point p) {
        this.p = p;
    }

    @Override
    public boolean equalTo(Object other) {
        int jPrime = 0;
        for (int j = 0; j < this.k; ++j) {
            jPrime = (j + this.d) % this.k;
            if (this.p.getCoord(jPrime) == ((HeapKey)other).getP().getCoord(jPrime)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean greaterThan(Object other) {
        int jPrime = 0;
        for (int j = 0; j < this.k; ++j) {
            jPrime = (j + this.d) % this.k;
            if (this.p.getCoord(jPrime) == ((HeapKey)other).getP().getCoord(jPrime)) continue;
            return this.p.getCoord(jPrime) >= ((HeapKey)other).getP().getCoord(jPrime);
        }
        return false;
    }

    @Override
    public boolean lessThan(Object other) {
        int jPrime = 0;
        for (int j = 0; j < this.k; ++j) {
            jPrime = (j + this.d) % this.k;
            if (this.p.getCoord(jPrime) == ((HeapKey)other).getP().getCoord(jPrime)) continue;
            return this.p.getCoord(jPrime) <= ((HeapKey)other).getP().getCoord(jPrime);
        }
        return false;
    }
}

