% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/margalef.R
\name{margalef}
\alias{margalef}
\title{Calculates Margalef's Species Richness}
\usage{
margalef(X, groups, species.table = NULL, metric = "ABUNDANCE", years)
}
\arguments{
\item{X}{A dataframe of fishery independent data derived from research vessel
survey data or model output, with columns \code{YEAR}, \code{ID},
\code{SPECIES}, and \code{ABUNDANCE}. \code{YEAR} indicates the year the
observation was recorded, \code{ID} is an area code indicating where the
observation was recorded, \code{SPECIES} is a numeric code indicating the
species sampled, and \code{ABUNDANCE} is the corresponding abundance
(stratified and corrected for catchability as required).}

\item{groups}{A vector indicating the species group(s) for which to calculate
the indicator. If \code{groups = "ALL"}, all species will be included;
otherwise, each entry must be a character string matching the name of a
column in \code{species.table}.}

\item{species.table}{A table where the column names match the entries in
\code{groups}. Column entries are species codes indicating the species from
\code{X} included in each group. \code{species.table} may also include
columns for other species groups; these will be ignored. If \code{groups =
"ALL"}, this table is not required. Default is \code{species.table = NULL}.}

\item{metric}{A character string indicating which column in \code{X} to use to
calculate the indicator. Default is \code{metric = "ABUNDANCE"}.}

\item{years}{A vector of years for which to calculate indicator.}
}
\value{
Returns a dataframe with columns \code{ID} and \code{YEAR}, and a
 column \code{MargalefRichness_group} for each entry in \code{groups}.

 If there is no data for spatial scale \eqn{j} in year \eqn{i}, indicator
 values is assigned \code{NA}.
}
\description{
This function calculates Margalef's Species Richness for \eqn{j}
 areas and \eqn{i} years.
}
\details{
Margalef's Species Richness: \deqn{S_{Marg} = (S_y - 1)/log(F_y)}
 \eqn{S_y} is the count of the number of species recorded in all trawl
 catches collected in year \eqn{y}. \eqn{F} is the total count of all
 individuals caught in year \eqn{y} (Margalef, 1958).
}
\examples{
data(X)
margalef(X, groups = c("ALL", "GROUNDFISH"), metric= "ABUNDANCE", years = c(2014:2019))
}
\references{
Bundy A, Gomez C, Cook AM. 2017. Guidance framework for the
 selection and evaluation of ecological indicators. Can. Tech. Rep. Fish.
 Aquat. Sci. 3232: xii + 212 p.

 Margalef R. 1958. Information theory in ecology. General Systems 3, 36–71.
}
\seealso{
Other biodiversity indicators: \code{\link{allBiodiversity}},
  \code{\link{heips}}, \code{\link{hillN1}},
  \code{\link{hillN2}}, \code{\link{kemptonQ}},
  \code{\link{pielouEvenness}}, \code{\link{shannon}},
  \code{\link{speciesRichness}}
}
\author{
Danielle Dempsey \email{Danielle.Dempsey@dfo-mpo.gc.ca}, Adam Cook,
 Catalina Gomez, Alida Bundy
}
\concept{biodiversity indicators}
