% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_traveltime_2000.R
\name{traveltime_2000}
\alias{traveltime_2000}
\alias{calc_traveltime_2000}
\title{Calculate accessibility statistics for the year 2000}
\usage{
calc_traveltime_2000(engine = "extract", stats = "mean")
}
\arguments{
\item{engine}{The preferred processing functions from either one of "zonal",
"extract" or "exactextract" as character.}

\item{stats}{Function to be applied to compute statistics for polygons either
single or multiple inputs as character. Supported statistics are: "mean",
"median", "sd", "min", "max", "sum", "var".}
}
\value{
A function that returns an indicator tibble with accessibility statistics
for the year 2000 as variables and corresponding values (in minutes) as values.
}
\description{
Accessibility refers to the ease with which cities can be reached from a
certain location. This function allows efficient calculation of accessibility
statistics (i.e., travel time to the nearest city) for polygons.  For each
polygon, the desired statistic/s (mean, median or sd) is/are returned.
}
\details{
The required resource for this indicator is:
\itemize{
\item \link{accessibility_2000}
}
}
\examples{
\dontshow{
mapme.biodiversity:::.copy_resource_dir(file.path(tempdir(), "mapme-data"))
}
\dontrun{
library(sf)
library(mapme.biodiversity)

outdir <- file.path(tempdir(), "mapme-data")
dir.create(outdir, showWarnings = FALSE)

mapme_options(
  outdir = outdir,
  verbose = FALSE
)

aoi <- system.file("extdata", "sierra_de_neiba_478140_2.gpkg",
  package = "mapme.biodiversity"
) \%>\%
  read_sf() \%>\%
  get_resources(get_accessibility_2000()) \%>\%
  calc_indicators(
    calc_traveltime_2000(stats = c("mean", "median", "sd"), engine = "extract")
  ) \%>\%
  portfolio_long()

aoi
}
}
\keyword{indicator}
