% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_ison.R
\docType{data}
\name{fict_potter}
\alias{fict_potter}
\title{Six complex one-mode support data in Harry Potter books (Bossaert and Meidert 2013)}
\format{
\if{html}{\out{<div class="sourceCode">}}\preformatted{#> # Harry Potter
#> # A longitudinal, labelled, complex, directed network of 64 students and 544
#> support arcs
#> # A tibble: 64 x 4
#>   name              schoolyear gender house     
#>   <chr>                  <int> <chr>  <chr>     
#> 1 Adrian Pucey            1989 male   Slytherin 
#> 2 Alicia Spinnet          1989 female Gryffindor
#> 3 Angelina Johnson        1989 female Gryffindor
#> 4 Anthony Goldstein       1991 male   Ravenclaw 
#> 5 Blaise Zabini           1991 male   Slytherin 
#> 6 C. Warrington           1989 male   Slytherin 
#> # i 58 more rows
#> # A tibble: 544 x 3
#>    from    to  wave
#>   <int> <int> <dbl>
#> 1     2     2     2
#> 2     2     2     3
#> 3     2     2     5
#> 4     2     3     2
#> 5     2     3     3
#> 6     2     3     5
#> # i 538 more rows
}\if{html}{\out{</div>}}
}
\usage{
data(fict_potter)
}
\description{
Goele Bossaert and Nadine Meidert coded peer support ties among 64 characters
in the Harry Potter books.
Each author coded four of seven books using NVivo,
with the seventh book coded by both and serving to assess inter-rater reliability.
The first six books concentrated on adolescent interactions,
were studied in their paper, and are made available here.
The peer support ties mean voluntary emotional, instrumental, or informational support,
or praise from one living, adolescent character to another within the book's pages.
In addition, nodal attributes name, schoolyear (which doubles as their age),
gender, and their house assigned by the sorting hat are included.
}
\references{
Bossaert, Goele and Nadine Meidert (2013).
"'We are only as strong as we are united, as weak as we are divided'. A dynamic analysis of the peer support networks in the Harry Potter books."
\emph{Open Journal of Applied Sciences}, 3(2): 174-185.
\doi{10.4236/ojapps.2013.32024}
}
\keyword{datasets}
