% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getNonDefaultArguments.R
\name{getNonDefaultArguments}
\alias{getNonDefaultArguments}
\title{getNonDefaultArguments}
\usage{
getNonDefaultArguments(call, args = NULL)
}
\arguments{
\item{call}{A function name as a string or symbol. Passing a vector of functions is possible, but is only intended
for corresponding read/correct/convert functions. If multiple functions in a vector define arguments with the same
name but different default values only the default defined in the first function is considered.}

\item{args}{A list of named arguments used to call the given function(s). If duplicates of arguments exists the first
occurrence of the argument will be used.}
}
\value{
A subset of args that is used by the function/s and is different from default values.
}
\description{
Given a function and an argument list, identify which arguments are different from their default.
}
\examples{
madrat:::getNonDefaultArguments("madrat:::readTau", args = list(subtype = "historical"))
madrat:::getNonDefaultArguments("madrat:::readTau", args = list(subtype = "paper"))
calls <- c(madrat:::readTau, madrat:::convertTau)
madrat:::getNonDefaultArguments(calls, args = list(subtype = "historical"))
}
\seealso{
\code{\link{cacheArgumentsHash}}, \code{\link{toolstartmessage}}
}
\author{
Jan Philipp Dietrich
}
