% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mable-dr.r
\name{mable.dr.group}
\alias{mable.dr.group}
\title{Mable fit of the density ratio model based on grouped data}
\usage{
mable.dr.group(
  t,
  n0,
  n1,
  M,
  regr,
  ...,
  interval = c(0, 1),
  alpha = NULL,
  vb = 0,
  controls = mable.ctrl(),
  progress = TRUE,
  message = TRUE
)
}
\arguments{
\item{t}{cutpoints of class intervals}

\item{n0, n1}{frequencies of two sample data grouped by the classes 
specified by \code{t}. code{n0}:"Control", \code{n1}: "Case".}

\item{M}{a positive integer or a vector \code{(m0, m1)}.}

\item{regr}{regressor vector function \eqn{r(x)=(1,r_1(x),...,r_d(x))} 
which returns n x (d+1) matrix, n=length(x)}

\item{...}{additional arguments to be passed to regr}

\item{interval}{a vector \code{(a,b)} containing the endpoints of 
supporting/truncation interval of x and y.}

\item{alpha}{a given regression coefficient, missing value is imputed by 
logistic regression}

\item{vb}{code for vanishing boundary constraints, -1: f0(a)=0 only, 
1: f0(b)=0 only, 2: both, 0: none (default).}

\item{controls}{Object of class \code{mable.ctrl()} specifying iteration limit
and the convergence criterion for EM and Newton iterations. Default is 
\code{\link{mable.ctrl}}. See Details.}

\item{progress}{logical: should a text progressbar be displayed}

\item{message}{logical: should warning messages be displayed}
}
\description{
Maximum approximate Bernstein/Beta likelihood estimation in a
  density ratio model based on two-sample grouped data.
}
\details{
Suppose that \code{n0} ("control") and \code{n1} ("case") are frequencies of  
independent samples grouped by the classes \code{t} from f0 and f1 which   
satisfy f1(x)=f0(x)exp[alpha0+alpha'r(x)] with r(x)=(r1(x),...,r_d(x)). Maximum 
approximate Bernstein/Beta likelihood estimates of (alpha0,alpha), f0 and f1 
are calculated. If support is (a,b) then replace r(x) by r[a+(b-a)x].
For a fixed \code{m}, using the Bernstein polynomial model for baseline \eqn{f_0},
MABLEs of \eqn{f_0} and parameters alpha can be estimated by EM algorithm and Newton  
iteration. If estimated lower bound \eqn{m_b} for \code{m} based on \code{n1}
is smaller that that based on \code{n0}, then switch \code{n0} and \code{n1} and
use \eqn{f_1} as baseline. If \code{M=m} or \code{m0=m1=m}, then \code{m} is a 
preselected degree. If \code{m0<m1} it specifies the set of consective  
candidate model degrees \code{m0:m1} for searching an optimal degree by 
the change-point method, where \code{m1-m0>3}.
}
