% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.R
\name{m5_get_raw}
\alias{m5_get_raw}
\alias{m5_get_raw_evaluation}
\alias{m5_get_raw_validation}
\title{Load raw CSV files using \code{\link[data.table:fread]{data.table::fread()}} function}
\usage{
m5_get_raw_evaluation(path)

m5_get_raw_validation(path)
}
\arguments{
\item{path}{The directory with the unzipped M5 data files}
}
\value{
The function returns a list of five data.tables:
\itemize{
\item sales_train (evaluation/validation)
\item sales_test (evaluation/validation)
\item sell_prices
\item calendar
\item weights (evaluation/validation)
}
}
\description{
Load raw CSV files using \code{\link[data.table:fread]{data.table::fread()}} function
}
\examples{
\dontrun{
library(m5)
library(zeallot)

m5_download('data')
c(sales_train,
  sales_test,
  sell_prices,
  calendar,
  ) \%<-\% m5_get_raw_evaluation('data')
}
}
\references{
\href{https://github.com/Nixtla/m5-forecasts}{m5-forecasts repo by Nixtla}
}
