% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approxExtrapDemand.R
\name{approxExtrapDemand}
\alias{approxExtrapDemand}
\title{Extrapolate land use area in time}
\usage{
approxExtrapDemand(obs, tout, ...)
}
\arguments{
\item{obs}{an ObsLulcRasterStack object containing at least two maps}

\item{tout}{numeric vector specifying the timesteps where interpolation is to
take place. Comparable to the \code{xout} argument of
\code{Hmisc::\link[Hmisc]{approxExtrap}}}

\item{\dots}{additional arguments to \code{Hmisc::\link[Hmisc]{approxExtrap}}}
}
\value{
A matrix.
}
\description{
Extrapolate land use area from two or more observed land use maps to provide
a valid (although not necessarily realistic) demand scenario.
}
\details{
Many allocation routines, including the two included with \code{lulcc},
require non-spatial estimates of land use demand for every timestep in the
study period. Some routines are coupled to complex economic models that
predict future or past land use demand based on economic considerations;
however, linear extrapolation of trends remains a useful technique.
}
\examples{

## Plum Island Ecosystems

## load observed land use maps
obs <- ObsLulcRasterStack(x=pie,
                   pattern="lu",
                   categories=c(1,2,3),
                   labels=c("forest","built","other"),
                   t=c(0,6,14))

## obtain demand scenario by interpolating between observed maps
dmd <- approxExtrapDemand(obs=obs, tout=c(0:14))

## plot
matplot(dmd, type="l", ylab="Demand (no. of cells)", xlab="Time point",
        lty=1, col=c("Green","Red","Blue"))
legend("topleft", legend=obs@labels, col=c("Green","Red","Blue"), lty=1)

## linear extrapolation is also possible
dmd <- approxExtrapDemand(obs=obs, tout=c(0:50))

## plot
matplot(dmd, type="l", ylab="Demand (no. of cells)", xlab="Time point",
        lty=1, col=c("Green","Red","Blue"))
legend("topleft", legend=obs@labels, col=c("Green","Red","Blue"), lty=1)

}
\seealso{
\code{Hmisc::\link[Hmisc]{approxExtrap}}
}
