% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loonGrob.R
\name{get_display_color}
\alias{get_display_color}
\title{Return the Displayed Color}
\usage{
get_display_color(color, selected)
}
\arguments{
\item{color}{the \code{loon} widget color}

\item{selected}{the selected states}
}
\value{
The color shown on the plot
}
\description{
Always reflect the current displayed color.
}
\details{
In \code{loon}, each element (i.e. point, bin, line) has a "temporary" color and
a "permanent" color. If one element is selected, the color is switched to the "temporary" color to highlight it.
If the selection state is eliminated, the "permanent" color of this element will be displayed.
Our function always gives the "temporary" displayed color.
}
\examples{
if(interactive()) {
  p <- l_plot(1:10)
  p['selected'][c(1,3,5)] <- TRUE

  displayedColor <- get_display_color(p['color'], p['selected'])
  plot(1:10, bg = as_hex6color(displayedColor), pch = 21)
}
}
