% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_ColorList.R
\name{l_colorName}
\alias{l_colorName}
\title{Get Color Names from the Hex Code}
\usage{
l_colorName(color, error = TRUE)
}
\arguments{
\item{color}{A vector of 12 digit (tcl) or 6 (8 with transparency) digit
color hex code, e.g. "#FFFF00000000", "#FF0000"}

\item{error}{Suppose the input is not a valid color, if \code{TRUE},
an error will be returned; else the input vector will be returned.}
}
\value{
A vector of built-in color names
}
\description{
Return the built-in color names by the given hex code.
}
\examples{
l_colorName(c("#FFFF00000000", "#FF00FF", "blue"))

\dontrun{
# an error will be returned
l_colorName(c("foo", "bar", "red"))

# c("foo", "bar", "red") will be returned
l_colorName(c("foo", "bar", "#FFFF00000000"), error = FALSE)
}
}
