% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_rename.R
\name{list_rename}
\alias{list_rename}
\title{Rename elements of a named list.}
\usage{
list_rename(in_list, ...)
}
\arguments{
\item{in_list}{The list to rename elements in.}

\item{...}{The renaming definitions.}
}
\value{
The list provided in `in_list` with elements renamed according to
the definition in `...`.
}
\description{
Rename elements of a named list.
}
\details{
`list_rename()` changes the name of elements in a named list. The definitions
for renaming are given in `...` in the style `new_name = old_name`.
You can specify as many renaming definitions as you like as long as there
are not more definitions than elements in the list.

If no renaming definition is given the input list is returned. If you try
to rename elements not present in the list nothing happens; unless you
provide more renaming definitions than elements in the list, in that case
an error is raised.
}
\examples{
my_list <- list(a = 1, b = 2, c = 3)
list_rename(my_list, AAA = "a", CCC = "c")
}
