% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_flatten.R
\name{list_flatten}
\alias{list_flatten}
\title{Flatten nested lists.}
\usage{
list_flatten(in_list, max_depth = -1)
}
\arguments{
\item{in_list}{The list to flatten}

\item{max_depth}{Maximum depth to recurse into.}
}
\value{
A list without nested lists.
}
\description{
`list_flatten()` works recursively through an input list and puts all
elements of nested list to the top level. If there are no nested lists
then the input is returned unchanged.
}
\details{
Using `max_depth` you can control whether to flatten all nested lists.
Negative values will cause all nested lists to be flattened, positive
depths will limit the depth of the recursion.
}
\examples{
my_list <- list(a = list(1, 2, 3), b = list(4, 5, 6))
list_flatten(my_list)
}
