% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lineqGPutils.R
\name{errorMeasureRegressMC}
\alias{errorMeasureRegressMC}
\title{Error Measures for GP Models using Monte Carlo Samples.}
\usage{
errorMeasureRegressMC(y, ytest, ysamples, type = "all",
  control = list(probs = c(0.05, 0.95)))
}
\arguments{
\item{y}{a vector with the output observations used for training.}

\item{ytest}{a vector with the output observations used for testing.}

\item{ysamples}{a matrix with posterior sample paths. Samples are indexed by columns.}

\item{type}{a character string corresponding to the type of the measure.}

\item{control}{an optional list with parameters to be passed (cia: "probs").}
}
\value{
The values of the error measures.
}
\description{
Compute error measures for GP models using Monte Carlo samples:
mean absulte error (\code{"mae"}), mean squared error (\code{"mse"}),
standardised mse (\code{"smse"}), Q2 (\code{"q2"}), predictive variance
adequation (\code{"pva"}), confidence interval accuracy (\code{"cia"}).
}
\examples{
# generating the toy example
n <- 100
w <- 4*pi
x <- seq(0, 1, length = n)
y <- sin(w*x)

# results with high-level noises generating the toy example
nbsamples <- 100
set.seed(1)
ynoise <- y + matrix(rnorm(n*nbsamples, 0, 10), ncol = nbsamples)
matplot(x, ynoise, type = "l", col = "gray70")
lines(x, y, lty = 2, col = "red")
legend("topright", c("target", "samples"), lty = c(2,1), col = c("red", "gray70"))
t(errorMeasureRegressMC(y, y, ynoise))

# results with low-level noises generating the toy example
set.seed(1)
ynoise <- y + matrix(rnorm(n*nbsamples, 0, 0.05), ncol = nbsamples)
matplot(x, ynoise, type = "l", col = "gray70")
lines(x, y, lty = 2, col = "red")
legend("topright", c("target", "samples"), lty = c(2,1), col = c("red", "gray70"))
t(errorMeasureRegressMC(y, y, ynoise))

}
\references{
Rasmussen, C. E. and Williams, C. K. I. (2005),
"Gaussian Processes for Machine Learning (Adaptive Computation and Machine Learning)".
\emph{The MIT Press}.
\href{http://www.gaussianprocess.org/gpml/}{[link]}

Bachoc, F. (2013),
"Cross validation and maximum likelihood estimations of hyper-parameters of
Gaussian processes with model misspecification".
\emph{Computational Statistics & Data Analysis},
66:55-69.
\href{https://www.sciencedirect.com/science/article/pii/S0167947313001187}{[link]}
}
\seealso{
\code{\link{errorMeasureRegress}}
}
\author{
A. F. Lopez-Lopera.
}
