% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/board.R
\name{new_board}
\alias{new_board}
\title{Initialize a Lights Out board with a given lights configuration}
\usage{
new_board(entries, classic = TRUE)
}
\arguments{
\item{entries}{The initial configuration of lights on the board. \code{entries}
can either be a vector or a matrix. If a vector is used, the vector is assumed
to start at the top-left corner of the board and is read row-by-row. Only values
of 0 (light off) and 1 (light on) are allowed in the vector or matrix. See
the examples below.}

\item{classic}{If \code{TRUE}, then pressing a light will toggle it and its
adjacent neighbours only. If \code{FALSE}, then pressing a light will toggle
the entire row and column of the pressed light.}
}
\value{
A \code{lightsout} board object.
}
\description{
Create a Lights Out board that can be played by the user or solved automatically.
Only square boards of size 3x3, 5x5, 7x7, or 9x9 are supported. The initial
lights configuration must be provided. To create a board with a random
configuration, use the \code{\link[lightsout]{random_board}} function.
}
\examples{
vector <- c(1, 1, 0,
            1, 0, 1,
            0, 1, 1)
new_board(entries = vector)

matrix <- matrix(
            c(1, 1, 0,
              1, 0, 1,
              0, 1, 1),
            nrow = 3, byrow = TRUE)
new_board(entries = matrix)
}
\seealso{
\code{\link[lightsout]{random_board}}
\code{\link[lightsout]{play}}
\code{\link[lightsout]{solve_board}}
}

