% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lgb.Dataset.R
\name{slice}
\alias{slice}
\alias{slice.lgb.Dataset}
\title{Slice a dataset}
\usage{
slice(dataset, idxset)

\method{slice}{lgb.Dataset}(dataset, idxset)
}
\arguments{
\item{dataset}{Object of class \code{lgb.Dataset}}

\item{idxset}{an integer vector of indices of rows needed}
}
\value{
constructed sub dataset
}
\description{
Get a new \code{lgb.Dataset} containing the specified rows of
             original \code{lgb.Dataset} object
}
\examples{
\donttest{
\dontshow{setLGBMthreads(2L)}
\dontshow{data.table::setDTthreads(1L)}
data(agaricus.train, package = "lightgbm")
train <- agaricus.train
dtrain <- lgb.Dataset(train$data, label = train$label)

dsub <- lightgbm::slice(dtrain, seq_len(42L))
lgb.Dataset.construct(dsub)
labels <- lightgbm::get_field(dsub, "label")
}
}
