% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/catalog_boundaries.R
\name{catalog_boundaries}
\alias{catalog_boundaries}
\title{Computes the polygon that encloses the points}
\usage{
catalog_boundaries(ctg, ...)
}
\arguments{
\item{ctg}{A LAScatalog}

\item{...}{propagated to \link{st_concave_hull}}
}
\value{
A LAScatalog with true boundaries
}
\description{
Computes the polygon that encloses the points. It reads all the files one by one and computes a
concave hull using the \link{st_concave_hull} function. When all the hulls are computed it updates the
LAScatalog to set the true polygons instead of the bounding boxes.
}
\section{Non-supported LAScatalog options}{

The options `select`, `output files`, `chunk size`, `chunk buffer`, `chunk alignment` are not
supported and not respected in  `catalog_boundaries*` because the function must always process by
file, without buffer and knows which attributes to load.
}

\examples{
LASfile <- system.file("extdata", "Megaplot.laz", package="lidR")
ctg <- readLAScatalog(LASfile, filter = "-drop_z_below 0.5")
ctg2 <- catalog_boundaries(ctg, concavity = 1, length_threshold = 15)
plot(ctg)
plot(ctg2, add = TRUE)
}
