% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Appender.R
\name{Appender}
\alias{Appender}
\alias{Appenders}
\title{Appenders}
\description{
Appenders are assigned to \link{Loggers} and
manage the output of the \link{LogEvents} to a destination, such as the console or
a text file. An Appender must have a single \link{Layout} that tells it how to
format the LogEvent. For details please refer to the documentations of the
specific Appenders.

\strong{Appender is not designed for direct usage}, but it is the basis on which all
other Appenders are built. Please see the \strong{see also} section towards the
end of this document a list of available Appenders.
}
\section{Usage}{
\preformatted{
x <- x$new(layout = Layout$new(), threshold = NA_integer_)

x$append(event)
x$set_threshold(level)
x$set_layout(layout)
x$filter(event)
x$add_filter(filter, name = NULL)
x$remove_filter(pos)
x$set_filters(filters)

x$destination
x$layout
x$threshold
x$filters

}
}

\section{Creating a New Appender}{


New Appenders are instantiated with \code{<AppenderSubclass>$new()}. For the
arguments to \code{new()} please refer to the section \emph{Fields}. You can also
modify those fields after the Appender has been created with setters in the
form of \code{appender$set_<fieldname>(value)}
}

\section{Fields}{


\describe{
\item{\code{threshold}, \code{set_threshold(level)}}{\code{character} or \code{integer} scalar.
The minimum log level that triggers this logger. See \link{log_levels}}
\item{\code{layout}, \code{set_layout(layout)}}{a \code{Layout} that will be used for
formatting the \code{LogEvents} passed to this Appender}
\item{\code{destination}}{The output destination of the \code{Appender} in
human-readable form (mainly for print output)}
}



\describe{
\item{\code{filters}, \code{set_filters(filters)}}{a \code{list} that may contain
\code{functions} or any \R object with a \code{filter()} method. These functions
must have exactly one argument: \code{event} which will get passed the
LogEvent when the Filterable's \code{filter()} method is invoked.
If all of these functions evaluate to \code{TRUE} the LogEvent is passed on.
Since LogEvents have reference semantics, filters can also be abused to
modify them before they are passed on. Look at the source code of
\code{\link[=with_log_level]{with_log_level()}} or \code{\link[=with_log_value]{with_log_value()}} for examples.
}
}
}

\section{Methods}{

\describe{
\item{\code{append(event)}}{Tell the Appender to process a \link{LogEvent} \code{event}.
This method is usually not called by the user, but invoked by a
\link{Logger}
}
}


\describe{
\item{\code{filter(event)}}{Determine whether the LogEvent \code{x} should be passed
on to Appenders (\code{TRUE}) or not (\code{FALSE}). See also the active binding
\code{filters}}
\item{\code{add_filter(filter, name = NULL)}, \code{remove_filter(pos)}}{
Add or remove a filter. When adding a filter an optional \code{name} can
be specified. \code{remove_filter()} can remove by position or name (if one
was specified)
}
}
}

\seealso{
Other Appenders: \code{\link{AppenderBuffer}},
  \code{\link{AppenderConsole}}, \code{\link{AppenderDbi}},
  \code{\link{AppenderFile}}, \code{\link{AppenderGmail}},
  \code{\link{AppenderJson}},
  \code{\link{AppenderPushbullet}},
  \code{\link{AppenderRjdbc}},
  \code{\link{AppenderSendmail}},
  \code{\link{AppenderTable}}
}
\concept{Appenders}
\keyword{internal}
