% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{supplemental}
\alias{supplemental}
\title{Create a Data Frame of Supplemental Data for MPM Development}
\usage{
supplemental(
  historical = TRUE,
  stagebased = TRUE,
  agebased = FALSE,
  stageframe = NULL,
  stage3 = NULL,
  stage2 = NULL,
  stage1 = NULL,
  age2 = NULL,
  eststage3 = NULL,
  eststage2 = NULL,
  eststage1 = NULL,
  estage2 = NULL,
  givenrate = NULL,
  multiplier = NULL,
  type = NULL,
  type_t12 = NULL
)
}
\arguments{
\item{historical}{A logical value indicating whether the MPMs intended will
be historical or ahistorical. Defaults to \code{TRUE}.}

\item{stagebased}{A logical value indicating whether the MPM will be stage-
based or age-by-stage. Defaults to \code{TRUE}.}

\item{agebased}{A logical value indicating whether the MPM will be age-based
or age-by-stage. Defaults to \code{FALSE}.}

\item{stageframe}{The stageframe used to produce the MPM. Required if
producing any stage-based or age-by-stage MPM. Must be omitted for purely
age-based MPMs.}

\item{stage3}{The name of the stage in occasion \emph{t}+1 in the transition
to be replaced. Abbreviations for groups of stages are also usable (see
\code{Notes}). Required in all stage-based and age-by-stage MPMs.}

\item{stage2}{The name of the stage in occasion \emph{t} in the transition
to be replaced. Abbreviations for groups of stages are also usable (see
\code{Notes}). Required in all stage-based and age-by-stage MPMs.}

\item{stage1}{The name of the stage in occasion \emph{t}-1 in the transition
to be replaced. Only needed if a historical matrix is to be produced.
Abbreviations for groups of stages are also usable (see \code{Notes}).
Required for historical stage-based MPMs.}

\item{age2}{An integer vector of the ages in occasion \emph{t} to use in
transitions to be changed or replaced. Required for all age- and
age-by-stage MPMs.}

\item{eststage3}{The name of the stage to replace \code{stage3} in a proxy
transition. Only needed if a transition will be replaced by another
estimated transition, and only in stage-based and age-by-stage MPMs.}

\item{eststage2}{The name of the stage to replace \code{stage2} in a proxy
transition. Only needed if a transition will be replaced by another
estimated transition, and only in stage-based and age-by-stage MPMs.}

\item{eststage1}{The name of the stage to replace \code{stage1} in a proxy
historical transition. Only needed if a transition will be replaced by
another estimated transition, and the matrix to be estimated is historical
and stage-based. Stage \code{NotAlive} is also possible for raw hMPMs as a
means of handling the prior stage for individuals entering the population in
occasion \emph{t}.}

\item{estage2}{The age at time \emph{t} to replace \code{age2} in a proxy
transition. Only needed if a transition will be replaced by another
estimated transition, and only in age-based and age-by-stage MPMs.}

\item{givenrate}{A fixed rate or probability to replace for the transition
described by \code{stage3}, \code{stage2}, and \code{stage1}.}

\item{multiplier}{A vector of numeric multipliers for fecundity or for proxy
transitions. Defaults to \code{1}.}

\item{type}{A vector denoting the kind of transition between occasions
\emph{t} and \emph{t}+1 to be replaced. This should be entered as \code{1},
\code{S}, or \code{s} for the replacement of a survival transition;
\code{2}, \code{F}, or \code{f} for the replacement of a fecundity
transition; or \code{3}, \code{R}, or \code{r} for a fecundity set value /
general multiplier. If empty or not provided, then defaults to \code{1} for
survival transition.}

\item{type_t12}{An optional vector denoting the kind of transition between
occasions \emph{t}-1 and \emph{t}. Only necessary if a historical MPM in
deVries format is desired. This should be entered as \code{1}, \code{S}, or
\code{s} for a survival transition; or \code{2}, \code{F}, or \code{f} for a
fecundity transitions. Defaults to \code{1} for survival transition, with
impacts only on the construction of deVries-format hMPMs.}
}
\value{
A data frame of class \code{lefkoSD}. This object can be used as
input in \code{\link{flefko3}()}, \code{\link{flefko2}()}, 
\code{\link{rlefko3}()}, \code{\link{rlefko2}()}, and 
\code{\link{aflefko2}()}.

Variables in this object include the following:
\item{stage3}{Stage at occasion \emph{t}+1 in the transition to be
replaced.}
\item{stage2}{Stage at occasion \emph{t} in the transition to be replaced.}
\item{stage1}{Stage at occasion \emph{t}-1 in the transition to be
replaced.}
\item{age2}{Age at occasion \emph{t} in the transition to be replaced.}
\item{eststage3}{Stage at occasion \emph{t}+1 in the transition to replace
the transition designated by \code{stage3}, \code{stage2}, and 
\code{stage1}.}
\item{eststage2}{Stage at occasion \emph{t} in the transition to replace the
transition designated by \code{stage3}, \code{stage2}, and \code{stage1}.}
\item{eststage1}{Stage at occasion \emph{t}-1 in the transition to replace
the transition designated by \code{stage3}, \code{stage2}, and 
\code{stage1}.}
\item{estage2}{Age at occasion \emph{t} in the transition to replace the
transition designated by \code{age2}.}
\item{givenrate}{A constant to be used as the value of the transition.}
\item{multiplier}{A multiplier for proxy transitions or for fecundity.}
\item{convtype}{Designates whether the transition from occasion \emph{t} to
occasion \emph{t}+1 is a survival transition probability (1), a fecundity
rate (2), or a fecundity multiplier (3).}
\item{convtype_t12}{Designates whether the transition from occasion
\emph{t}-1 to occasion \emph{t} is a survival transition probability (1), a
fecundity rate (2).}
}
\description{
Function \code{supplemental()} provides all necessary supplemental data for
matrix estimation, particularly bringing together data on proxy rates, data
to overwrite existing rates, identified reproductive transitions complete,
and fecundity multipliers. The function should be used to incorporate data
that affects all matrices to be created. To edit MPMs after creation, use
\code{\link{edit_lM}()} instead.
}
\section{Notes}{

Negative values are not allowed in \code{givenrate} and \code{multiplier}
input. Stage entries should not be used for purely age-based MPMs, and age
entries should not be used for purely stage-based MPMs.

Fecundity multiplier data supplied via the \code{supplemental()} function
acts in the same way as non-zero entries supplied via a reproductive matrix,
but gets priority in all matrix creations. Thus, in cases where fecundity
multipliers are provided for the same function via the reproductive matrix
and function \code{supplemental()}, the latter is used.

Entries in \code{stage3}, \code{stage2}, and \code{stage1} can include
abbreviations for groups of stages. Use \code{rep} if all reproductive
stages are to be used, \code{nrep} if all mature but non-reproductive stages
are to be used, \code{mat} if all mature stages are to be used, \code{immat}
if all immature stages are to be used, \code{prop} if all propagule stages
are to be used, \code{npr} if all non-propagule stages are to be used,
\code{obs} if all observable stages are to be used, \code{nobs} if all
unobservable stages are to be used, and leave empty or use \code{all} if all
stages in stageframe are to be used. Also use \code{groupX} to denote all
stages in group X (e.g. \code{group1} will use all stages in the respective
stageframe's group 1).

Type 3 conversions are referred to as fecundity set values, or general
fecundity multipliers. These set the transitions to be used as fecundity
transitions. Transitions set here will be interpreted as being generally
reproductive, meaning that the from and to stages will be used to determine
the general fecundity transitions to incorporate into stage-based MPMs,
while the age portion of the input will be used to incorporate the actual
multiplier(s) specified. If only stage transitions at certain ages are
expected to be the sole contributors to fecundity, then type 2 conversions
should also be included in the supplement (Type 1 and 2 conversions can be
purely age-specific, and do not set reproductive transitions in MPM
creation). For example, if all stage 2 to stage 3 transitions above age 2
yield fecundity, then stage 2 to stage 3 can be set to
\code{multiplier = 1.0} with \code{convtype = 3}, and the same transition
for \code{age2 = c(1, 2)} can be set to \code{multiplier = c(0, 0)}.
}

\examples{
# Lathyrus example
data(lathyrus)

sizevector <- c(0, 100, 13, 127, 3730, 3800, 0)
stagevector <- c("Sd", "Sdl", "VSm", "Sm", "VLa", "Flo", "Dorm")
repvector <- c(0, 0, 0, 0, 0, 1, 0)
obsvector <- c(0, 1, 1, 1, 1, 1, 0)
matvector <- c(0, 0, 1, 1, 1, 1, 1)
immvector <- c(1, 1, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0)
indataset <- c(0, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 100, 11, 103, 3500, 3800, 0.5)

lathframe <- sf_create(sizes = sizevector, stagenames = stagevector,
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
  immstatus = immvector, indataset = indataset, binhalfwidth = binvec,
  propstatus = propvector)

lathvert <- verticalize3(lathyrus, noyears = 4, firstyear = 1988,
  patchidcol = "SUBPLOT", individcol = "GENET", blocksize = 9,
  juvcol = "Seedling1988", sizeacol = "Volume88", repstracol = "FCODE88",
  fecacol = "Intactseed88", deadacol = "Dead1988",
  nonobsacol = "Dormant1988", stageassign = lathframe, stagesize = "sizea",
  censorcol = "Missing1988", censorkeep = NA, censor = TRUE)

lathsupp3 <- supplemental(stage3 = c("Sd", "Sd", "Sdl", "Sdl", "Sd", "Sdl", "mat"),
  stage2 = c("Sd", "Sd", "Sd", "Sd", "rep", "rep", "Sdl"),
  stage1 = c("Sd", "rep", "Sd", "rep", "npr", "npr", "Sd"),
  eststage3 = c(NA, NA, NA, NA, NA, NA, "mat"),
  eststage2 = c(NA, NA, NA, NA, NA, NA, "Sdl"),
  eststage1 = c(NA, NA, NA, NA, NA, NA, "NotAlive"),
  givenrate = c(0.345, 0.345, 0.054, 0.054, NA, NA, NA),
  multiplier = c(NA, NA, NA, NA, 0.345, 0.054, NA),
  type = c(1, 1, 1, 1, 3, 3, 1), type_t12 = c(1, 2, 1, 2, 1, 1, 1),
  stageframe = lathframe, historical = TRUE)

ehrlen3 <- rlefko3(data = lathvert, stageframe = lathframe, year = "all", 
  stages = c("stage3", "stage2", "stage1"), supplement = lathsupp3,
  yearcol = "year2", indivcol = "individ")

# Cypripedium example
data(cypdata)

sizevector <- c(0, 0, 0, 0, 0, 0, 1, 2.5, 4.5, 8, 17.5)
stagevector <- c("SD", "P1", "P2", "P3", "SL", "D", "XSm", "Sm", "Md", "Lg",
  "XLg")
repvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
obsvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
matvector <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
immvector <- c(0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
indataset <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 0, 0, 0, 0, 0.5, 0.5, 1, 1, 2.5, 7)

cypframe_raw <- sf_create(sizes = sizevector, stagenames = stagevector,
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
  propstatus = propvector, immstatus = immvector, indataset = indataset,
  binhalfwidth = binvec)

cypraw_v1 <- verticalize3(data = cypdata, noyears = 6, firstyear = 2004,
  patchidcol = "patch", individcol = "plantid", blocksize = 4,
  sizeacol = "Inf2.04", sizebcol = "Inf.04", sizeccol = "Veg.04",
  repstracol = "Inf.04", repstrbcol = "Inf2.04", fecacol = "Pod.04",
  stageassign = cypframe_raw, stagesize = "sizeadded", NAas0 = TRUE,
  NRasRep = TRUE)

cypsupp2r <- supplemental(stage3 = c("SD", "P1", "P2", "P3", "SL", "D", 
    "XSm", "Sm", "SD", "P1"),
  stage2 = c("SD", "SD", "P1", "P2", "P3", "SL", "SL", "SL", "rep",
    "rep"),
  eststage3 = c(NA, NA, NA, NA, NA, "D", "XSm", "Sm", NA, NA),
  eststage2 = c(NA, NA, NA, NA, NA, "XSm", "XSm", "XSm", NA, NA),
  givenrate = c(0.10, 0.20, 0.20, 0.20, 0.25, NA, NA, NA, NA, NA),
  multiplier = c(NA, NA, NA, NA, NA, NA, NA, NA, 0.5, 0.5),
  type =c(1, 1, 1, 1, 1, 1, 1, 1, 3, 3),
  stageframe = cypframe_raw, historical = FALSE)

cypmatrix2r <- rlefko2(data = cypraw_v1, stageframe = cypframe_raw, 
  year = "all", patch = "all", stages = c("stage3", "stage2", "stage1"),
  size = c("size3added", "size2added"), supplement = cypsupp2r,
  yearcol = "year2", patchcol = "patchid", indivcol = "individ")

}
\seealso{
\code{\link{edit_lM}()}
}
