% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/question_methods.R
\name{correct}
\alias{correct}
\alias{incorrect}
\alias{mark_as}
\title{Question is correct value}
\usage{
correct(messages = NULL)

incorrect(messages = NULL)

mark_as(correct, messages = NULL)
}
\arguments{
\item{messages}{a vector of messages to be displayed.  The type of message will be determined by the \code{correct} value.}

\item{correct}{boolean that determines if a question answer is correct}
}
\description{
Helper method to return
}
\examples{
# Radio button question implementation of `question_is_correct`
question_is_correct.radio <- function(question, value, ...) {
  for (ans in question$answers) {
    if (as.character(ans$option) == value) {
      return(mark_as(
        ans$correct,
        ans$message
      ))
    }
  }
  mark_as(FALSE, NULL)
}
}
