% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lp_quiz_responses.R
\name{lp_quiz_responses}
\alias{lp_quiz_responses}
\title{Leanpub Quiz Responses for a Course}
\usage{
lp_quiz_responses(
  slug,
  anonymized_id = NULL,
  body = list(),
  api_key = NULL,
  secure = TRUE,
  verbose = TRUE,
  query = list(),
  ...
)
}
\arguments{
\item{slug}{slug of the project}

\item{anonymized_id}{Anonymized ID for a single user.
For a single user's CSV, you will get the JSON response immediately.}

\item{body}{body sent to \code{\link[httr]{POST}}}

\item{api_key}{API key for Leanpub, passed to \code{\link{lp_api_key}}}

\item{secure}{passed to \code{\link{lp_base_url}} for https}

\item{verbose}{print diagnostic messages}

\item{query}{query information to send to \code{\link[httr]{POST}}}

\item{...}{additional options to pass to \code{\link[httr]{GET}}}
}
\value{
List of the result of the \code{\link[httr]{POST}} call and
the content
}
\description{
Leanpub Quiz Responses for a Course
}
\note{
See Author -> Courses -> Course Name -> Quiz Responses
on Leanpub
}
\examples{
\dontrun{
if (lp_have_api_key()) {
slug = "muschellitestcourse"
res = lp_quiz_responses(slug, error = FALSE, verbose = 2)
}
}
}
