% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{SurSearch}
\alias{SurSearch}
\title{SUR Search}
\usage{
SurSearch(
  y,
  x,
  numTargets = 1L,
  xSizes = NULL,
  xPartitions = NULL,
  numFixXPartitions = 0L,
  yGroups = NULL,
  searchSigMaxIter = 0L,
  searchSigMaxProb = 0.1,
  measureOptions = NULL,
  modelCheckItems = NULL,
  searchItems = NULL,
  searchOptions = NULL
)
}
\arguments{
\item{y}{(numeric matrix) endogenous data with variables in the columns.}

\item{x}{(numeric matrix) exogenous data with variables in the columns.}

\item{numTargets}{(int) determines the number of variable in the first columns of \code{y} for which the information is saved. It must be positive and cannot be larger than the number of endogenous variables.}

\item{xSizes}{(nullable integer vector) Number of exogenous variables in the regressions. E.g., c(1,2) means the model set contains all the regressions with 1 and 2 exogenous variables. If null, c(1) is used.}

\item{xPartitions}{(nullable list of integer vector) a partition over the indexes of the exogenous variables. No regression is estimated with two variables in the same group. If \code{NULL}, each variable is placed in its own group and the size of the model set is maximized.}

\item{numFixXPartitions}{(int) number of partitions at the beginning of \code{xPartitions} to be included in all regressions.}

\item{yGroups}{(nullable list of integer vector) different combinations of the indexes of the endogenous variables to be used as endogenous variables in the SUR regressions.}

\item{searchSigMaxIter}{(int) maximum number of iterations in searching for significant coefficients. Use 0 to disable the search.}

\item{searchSigMaxProb}{(double) maximum value of type I error to be used in searching for significant coefficients. If p-value is less than this, it is interpreted as significant.}

\item{measureOptions}{(nullable list) see \code{[GetMeasureOptions()]}.}

\item{modelCheckItems}{(nullable list) see \code{[GetModelCheckItems()]}.}

\item{searchItems}{(nullable list) see \code{[GetSearchItems()]}.}

\item{searchOptions}{(nullable list) see \code{[GetSearchOptions()]}.}
}
\value{
A list
}
\description{
SUR Search
}
